/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.model.ModelBlastRing;
import io.github.kadir1243.rivalrebels.client.model.ModelBlastSphere;
import io.github.kadir1243.rivalrebels.client.model.ModelTsarBlast;
import io.github.kadir1243.rivalrebels.common.entity.EntityTachyonBombBlast;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class RenderTachyonBombBlast
extends EntityRenderer<EntityTachyonBombBlast, State> {
    private final ModelTsarBlast model = new ModelTsarBlast();

    public RenderTachyonBombBlast(EntityRendererProvider.Context manager) {
        super(manager);
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        double radius = (renderState.deltaMovement.x() * 10.0 - 1.0) * (renderState.deltaMovement.x() * 10.0 - 1.0) * 2.0 + (double)RRConfig.SERVER.getTsarBombaStrength();
        poseStack.pushPose();
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.solid());
        if (renderState.ageInTicks < 60.0f) {
            double elev = renderState.ageInTicks / 5.0f;
            poseStack.translate(0.0, elev, 0.0);
            ModelBlastSphere.renderModel(poseStack, bufferSource, renderState.ageInTicks * RRConfig.CLIENT.getShroomScale(), -1);
        } else if (renderState.ageInTicks < 600.0f && radius - (double)RRConfig.SERVER.getTsarBombaStrength() > 9.0) {
            double elev = (renderState.ageInTicks - 60.0f) / 32.0f + 10.0f;
            poseStack.pushPose();
            poseStack.scale(RRConfig.CLIENT.getShroomScale() * 2.0f, RRConfig.CLIENT.getShroomScale(), RRConfig.CLIENT.getShroomScale() * 2.0f);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(elev * 2.0)));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees((float)(elev * 3.0)));
            ModelBlastSphere.renderModel(poseStack, bufferSource, (float)elev, 1.0f, 0.25f, 0.0f, 1.0f);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.scale(RRConfig.CLIENT.getShroomScale() * 2.0f, RRConfig.CLIENT.getShroomScale(), RRConfig.CLIENT.getShroomScale() * 2.0f);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(elev * -2.0)));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)(elev * 4.0)));
            ModelBlastSphere.renderModel(poseStack, bufferSource, (float)(elev - (double)0.2f), 1.0f, 0.5f, 0.0f, 1.0f);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.translate(0.0, elev * 4.0, 0.0);
            poseStack.scale(RRConfig.CLIENT.getShroomScale(), RRConfig.CLIENT.getShroomScale() * 3.0f, RRConfig.CLIENT.getShroomScale());
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees((float)(elev * -3.0)));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)(elev * 2.0)));
            ModelBlastSphere.renderModel(poseStack, bufferSource, (float)(elev - (double)0.4f), -65536);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.translate(0.0, elev * 4.0, 0.0);
            poseStack.scale(RRConfig.CLIENT.getShroomScale(), RRConfig.CLIENT.getShroomScale() * 3.0f, RRConfig.CLIENT.getShroomScale());
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(elev * -1.0)));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)(elev * 3.0)));
            ModelBlastSphere.renderModel(poseStack, bufferSource, (float)(elev - (double)0.6f), 1.0f, 1.0f, 0.0f, 1.0f);
            poseStack.popPose();
        } else {
            float elev = (renderState.ageInTicks - (radius - (double)RRConfig.SERVER.getTsarBombaStrength() > 9.0 ? 600.0f : 0.0f)) / 8.0f;
            ModelBlastRing.renderModel(poseStack, buffer, RRConfig.CLIENT.getShroomScale() * elev * 1.0f, 32, 2.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, packedLight);
            ModelBlastRing.renderModel(poseStack, buffer, RRConfig.CLIENT.getShroomScale() * elev * 1.1f, 32, 2.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 6.0f, 0.0f, packedLight);
            ModelBlastRing.renderModel(poseStack, buffer, RRConfig.CLIENT.getShroomScale() * elev * 1.2f, 32, 2.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 10.0f, 0.0f, packedLight);
            ModelBlastRing.renderModel(poseStack, buffer, RRConfig.CLIENT.getShroomScale() * elev * 1.3f, 32, 2.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 14.0f, 0.0f, packedLight);
            ModelBlastRing.renderModel(poseStack, buffer, RRConfig.CLIENT.getShroomScale() * elev * 1.4f, 32, 2.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 18.0f, 0.0f, packedLight);
            ModelBlastRing.renderModel(poseStack, buffer, RRConfig.CLIENT.getShroomScale() * elev * 1.5f, 32, 2.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 22.0f, 0.0f, packedLight);
            ModelBlastRing.renderModel(poseStack, buffer, RRConfig.CLIENT.getShroomScale() * elev * 1.6f, 32, 2.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 26.0f, 0.0f, packedLight);
            ModelBlastRing.renderModel(poseStack, buffer, RRConfig.CLIENT.getShroomScale() * elev * 1.7f, 32, 2.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 30.0f, 0.0f, packedLight);
            poseStack.translate(0.0, 10.0 + (renderState.deltaMovement.x() - 0.1) * 14.14213562, 0.0);
            poseStack.scale(RRConfig.CLIENT.getShroomScale(), RRConfig.CLIENT.getShroomScale(), RRConfig.CLIENT.getShroomScale());
            float horizontal = elev * 0.025f + 1.0f;
            poseStack.scale((float)((double)horizontal * radius * (double)0.116f), (float)(radius * (double)0.065f), (float)((double)horizontal * radius * (double)0.116f));
            poseStack.scale(0.8f, 0.8f, 0.8f);
            this.model.render(poseStack, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)RRIdentifiers.ettsarflame)), packedLight, OverlayTexture.NO_OVERLAY);
        }
        poseStack.popPose();
    }

    public boolean shouldRender(EntityTachyonBombBlast livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    protected int getBlockLightLevel(EntityTachyonBombBlast entity, BlockPos pos) {
        return 15;
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(EntityTachyonBombBlast p_entity, State reusedState, float partialTick) {
        super.extractRenderState((Entity)p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.deltaMovement = p_entity.getDeltaMovement();
    }

    public static class State
    extends EntityRenderState {
        public Vec3 deltaMovement;
    }
}

