/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.client.model.ObjModels;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodesPiece;
import io.github.kadir1243.rivalrebels.common.entity.RhodesType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public abstract class RhodesPartRenderer<T extends EntityRhodesPiece>
extends EntityRenderer<T, State> {
    private final QuadCollection model;

    public RhodesPartRenderer(EntityRendererProvider.Context context, StandaloneModelKey<QuadCollection> modelLocation) {
        super(context);
        this.model = (QuadCollection)context.getModelManager().getStandaloneModel(modelLocation);
    }

    public ResourceLocation getTextureLocation(State entity) {
        return ((RhodesType)entity.variant.value()).getTexture();
    }

    public void render(State renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(renderState.scale, renderState.scale, renderState.scale);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.xRot));
        this.renderParts(renderState, poseStack, bufferSource, packedLight);
        poseStack.popPose();
    }

    public void renderParts(State entity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (this.model != null) {
            ObjModels.render(this.model, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)this.getTextureLocation(entity))), poseStack, entity.color, packedLight, OverlayTexture.NO_OVERLAY);
        }
    }

    public boolean shouldRender(T livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public State createRenderState() {
        return new State();
    }

    public void extractRenderState(T p_entity, State reusedState, float partialTick) {
        super.extractRenderState(p_entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = p_entity.getXRot(partialTick);
        reusedState.yRot = p_entity.getYRot(partialTick);
        reusedState.scale = ((EntityRhodesPiece)((Object)p_entity)).getScale();
        reusedState.variant = ((EntityRhodesPiece)((Object)p_entity)).getVariant();
        reusedState.color = ((EntityRhodesPiece)((Object)p_entity)).getColorRGBA();
    }

    public static class State
    extends EntityRenderState {
        public float xRot;
        public float yRot;
        public float scale;
        public Holder<RhodesType> variant;
        public int color;
    }
}

