/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderhelper;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Transformation;
import io.github.kadir1243.rivalrebels.client.renderhelper.TextureFace;
import io.github.kadir1243.rivalrebels.client.renderhelper.TextureVertice;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.QuadCollection;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.neoforged.neoforge.client.model.pipeline.TransformingVertexPipeline;
import net.neoforged.neoforge.client.model.pipeline.VertexConsumerWrapper;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class QuadHelper {
    public static void addFace(VertexConsumer buffer, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, TextureVertice t1, TextureVertice t2, TextureVertice t3, TextureVertice t4) {
        QuadHelper.addVertice(buffer, v1, t1);
        QuadHelper.addVertice(buffer, v2, t2);
        QuadHelper.addVertice(buffer, v3, t3);
        QuadHelper.addVertice(buffer, v4, t4);
    }

    public static void addFace(VertexConsumer buffer, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, int color) {
        QuadHelper.addVertice(buffer, v1, color);
        QuadHelper.addVertice(buffer, v2, color);
        QuadHelper.addVertice(buffer, v3, color);
        QuadHelper.addVertice(buffer, v4, color);
    }

    public static void addFace(VertexConsumer buffer, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, TextureFace t) {
        QuadHelper.addFace(buffer, v1, v2, v3, v4, t.v1(), t.v2(), t.v3(), t.v4());
    }

    public static void addFace(VertexConsumer buffer, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, float x1, float x2, float y2, float y1) {
        QuadHelper.addVertice(buffer, v1, new TextureVertice(x1, y1));
        QuadHelper.addVertice(buffer, v2, new TextureVertice(x2, y1));
        QuadHelper.addVertice(buffer, v3, new TextureVertice(x2, y2));
        QuadHelper.addVertice(buffer, v4, new TextureVertice(x1, y2));
    }

    public static void addVertice(VertexConsumer buffer, Vector3f v, TextureVertice t, int color) {
        buffer.addVertex(v).setColor(color).setUv(t.x(), t.y()).setNormal(0.0f, 0.0f, 1.0f);
    }

    public static void addVertice(VertexConsumer buffer, Vector3f v, TextureVertice t, int color, Vector3f normal) {
        buffer.addVertex(v).setColor(color).setUv(t.x(), t.y()).setNormal(normal.x(), normal.y(), normal.z());
    }

    public static void addVertice(VertexConsumer buffer, Vector3f v, TextureVertice t) {
        QuadHelper.addVertice(buffer, v, t, -1);
    }

    public static void addVertice(VertexConsumer buffer, Vector3f v, TextureVertice t, Vector3f normal) {
        QuadHelper.addVertice(buffer, v, t, -1, normal);
    }

    public static void addVertice(VertexConsumer buffer, Vector3f v, int color) {
        buffer.addVertex(v).setColor(color).setUv(16.0f, 16.0f);
    }

    public static Supplier<BakedData> createBakedModel(Consumer<VertexConsumer> bakedQuadSupplier) {
        return Suppliers.memoize(() -> {
            QuadCollection model = QuadHelper.createBakedModel(bakedQuadSupplier, Transformation.identity());
            SimpleModelWrapper wrapped = new SimpleModelWrapper(model, false, Minecraft.getInstance().getGuiSprites().getSprite(MissingTextureAtlasSprite.getLocation()));
            return new BakedData(new SingleVariant((BlockModelPart)wrapped), (BlockModelPart)wrapped);
        });
    }

    public static QuadCollection createBakedModel(Consumer<VertexConsumer> bakedQuadSupplier, Transformation transforms) {
        final QuadBakingVertexConsumer buffer = new QuadBakingVertexConsumer();
        buffer.setSprite(Minecraft.getInstance().getGuiSprites().getSprite(TextureAtlas.LOCATION_BLOCKS));
        final QuadCollection.Builder builder = new QuadCollection.Builder();
        bakedQuadSupplier.accept((VertexConsumer)new VertexConsumerWrapper((VertexConsumer)new TransformingVertexPipeline((VertexConsumer)buffer, transforms)){
            private int vertexCount;

            public VertexConsumer addVertex(float x, float y, float z) {
                super.addVertex(x, y, z);
                ++this.vertexCount;
                if (this.vertexCount == 4) {
                    builder.addUnculledFace(buffer.bakeQuad());
                    this.vertexCount = 0;
                }
                return this;
            }
        });
        return builder.build();
    }

    public record BakedData(SingleVariant blockStateModel, BlockModelPart original) {
    }
}

