/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.renderhelper;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.kadir1243.rivalrebels.client.renderhelper.GuiTrayModelRenderer;
import io.github.kadir1243.rivalrebels.client.renderhelper.TrayModelPIPRenderState;
import io.github.kadir1243.rivalrebels.common.noise.RivalRebelsCellularNoise;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterNamedRenderTypesEvent;
import net.neoforged.neoforge.client.event.RegisterPictureInPictureRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterRenderPipelinesEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderTypes {
    public static final RenderPipeline COLOR_WRITE_QUAD = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.ENTITY_SNIPPET}).withColorWrite(true).withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS).withLocation("pipeline/solid").build();
    public static final RenderPipeline COLOR_WRITE_TRI = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.ENTITY_SNIPPET}).withColorWrite(true).withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.TRIANGLES).withLocation("pipeline/solid").build();
    public static final RenderType LIGHTNING_ASTRO_BLAST = RenderType.create((String)"rivalrebels_lightning_astro_blast", (int)99999, (RenderPipeline)COLOR_WRITE_QUAD, (RenderType.CompositeState)RenderType.CompositeState.builder().setOutputState(RenderStateShard.TRANSLUCENT_TARGET).createCompositeState(false));
    public static final RenderType LIGHTNING_ASTRO_BLAST_TRIANGLES = RenderType.create((String)"rivalrebels_lightning_astro_blast_triangles", (int)99999, (RenderPipeline)COLOR_WRITE_TRI, (RenderType.CompositeState)RenderType.CompositeState.builder().setOutputState(RenderStateShard.TRANSLUCENT_TARGET).createCompositeState(false));
    public static final RenderType MODEL_BLAST_SPHERE_TRIANGLES = RenderType.create((String)"rivalrebels_model_blast_sphere_triangles", (int)1536, (RenderPipeline)COLOR_WRITE_TRI, (RenderType.CompositeState)RenderType.CompositeState.builder().setOutputState(RenderStateShard.TRANSLUCENT_TARGET).createCompositeState(false));
    public static final RenderPipeline CELLULAR_NOISE_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.ENTITY_SNIPPET}).withLocation("pipeline/entity_solid").withVertexFormat(DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS).withSampler("Sampler1").build();
    public static final RenderType CELLULAR_NOISE = RenderType.create((String)"rivalrebels_cellular_noise", (int)999, (RenderPipeline)CELLULAR_NOISE_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setOutputState(RenderStateShard.TRANSLUCENT_TARGET).setTextureState(new RenderStateShard.EmptyTextureStateShard(() -> RenderSystem.setShaderTexture((int)0, (GpuTextureView)RivalRebelsCellularNoise.getCurrentRandomId().getTextureView()), () -> {})).createCompositeState(false));
    public static final RenderPipeline LASER_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.ENTITY_SNIPPET}).withLocation("pipeline/entity_translucent").withCull(true).withBlend(BlendFunction.ADDITIVE).withSampler("Sampler1").build();
    public static final RenderPipeline RHODES_LASER_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.ENTITY_SNIPPET}).withLocation("pipeline/entity_translucent").withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.TRIANGLES).withColorWrite(false, false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withBlend(BlendFunction.ADDITIVE).withSampler("Sampler1").build();
    public static final RenderType LASER_RENDER_TYPE = RenderType.create((String)"rivalrebels_laser_render_type", (int)1536, (boolean)true, (boolean)false, (RenderPipeline)LASER_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setOutputState(RenderStateShard.TRANSLUCENT_TARGET).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(true));
    public static final RenderType RHODES_LIGHTNING = RenderType.create((String)"rivalrebels_rhodes_lightning", (int)1536, (RenderPipeline)RHODES_LASER_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setOutputState(RenderStateShard.TRANSLUCENT_TARGET).createCompositeState(false));
    public static final RenderPipeline ENTITY_SOLID_TRIANGLES = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.ENTITY_SNIPPET}).withVertexFormat(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.TRIANGLES).withLocation("pipeline/entity_solid").withSampler("Sampler1").build();
    public static final Function<ResourceLocation, RenderType> RENDER_SOLID_TRIANGLES = Util.memoize(resourceLocation -> {
        RenderType.CompositeState rendertype$compositestate = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false)).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(true);
        return RenderType.create((String)"rivalrebels_render_solid_triangles", (int)1536, (boolean)true, (boolean)false, (RenderPipeline)ENTITY_SOLID_TRIANGLES, (RenderType.CompositeState)rendertype$compositestate);
    });
    public static final RenderPipeline LASER_LINK_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.ENTITY_SNIPPET}).withLocation("pipeline/entity_translucent").withVertexShader("core/rendertype_lightning").withFragmentShader("core/rendertype_lightning").withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS).withColorWrite(false, false).withBlend(BlendFunction.ADDITIVE).withDepthWrite(true).withSampler("Sampler1").build();
    public static final RenderType LASER_LINK_ENTITY = RenderType.create((String)"rivalrebels_laser_link_entity", (int)1536, (RenderPipeline)LASER_LINK_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().createCompositeState(false));
    public static final RenderPipeline ANTIMATTER_BOMB_BLAST_ENTITY_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.ENTITY_SNIPPET}).withLocation("pipeline/entity_translucent").withVertexShader("core/rendertype_lightning").withFragmentShader("core/rendertype_lightning").withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.TRIANGLES).withBlend(BlendFunction.ADDITIVE).withDepthWrite(true).withSampler("Sampler1").build();
    public static final RenderType ANTIMATTER_BOMB_BLAST_ENTITY = RenderType.create((String)"rivalrebels_antimatter_bomb_blast_entity", (int)1536, (RenderPipeline)ANTIMATTER_BOMB_BLAST_ENTITY_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().createCompositeState(false));
    public static final RenderPipeline LIGHTNING_LINK_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.MATRICES_FOG_SNIPPET}).withLocation("pipeline/entity_translucent").withVertexShader("core/rendertype_lightning").withFragmentShader("core/rendertype_lightning").withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS).withBlend(BlendFunction.LIGHTNING).withSampler("Sampler1").build();
    public static final RenderType LIGHTNING_LINK = RenderType.create((String)"rivalrebels_lightning_link", (int)1536, (boolean)false, (boolean)true, (RenderPipeline)LIGHTNING_LINK_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().createCompositeState(false));

    public static void registerRenderTypes(RegisterNamedRenderTypesEvent event) {
    }

    public static void registerRenderPipelines(RegisterRenderPipelinesEvent event) {
    }

    public static void registerPIPRenderer(RegisterPictureInPictureRenderersEvent event) {
        event.register(TrayModelPIPRenderState.class, bufferSource -> new GuiTrayModelRenderer((MultiBufferSource.BufferSource)bufferSource, Minecraft.getInstance().getModelManager()));
    }
}

