/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.tileentityrender;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.client.model.ModelBlastSphere;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityMeltDown;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityMeltdownRenderer
implements BlockEntityRenderer<TileEntityMeltDown> {
    public TileEntityMeltdownRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityMeltDown blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        float fsize = Mth.sin((float)blockEntity.size);
        if (fsize <= 0.0f) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(blockEntity.size * 50.0f));
        ModelBlastSphere.renderModel(poseStack, bufferSource, fsize * 5.5f, 1.0f, 1.0f, 1.0f, 0.4f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(blockEntity.size * 50.0f));
        ModelBlastSphere.renderModel(poseStack, bufferSource, fsize * 5.6f, 1.0f, 1.0f, 1.0f, 0.4f);
        poseStack.popPose();
        ModelBlastSphere.renderModel(poseStack, bufferSource, fsize * 5.9f, 1.0f, 1.0f, 1.0f, 0.4f);
        poseStack.popPose();
    }

    public int getViewDistance() {
        return 16384;
    }

    public AABB getRenderBoundingBox(TileEntityMeltDown blockEntity) {
        return AABB.of((BoundingBox)BoundingBox.fromCorners((Vec3i)blockEntity.getBlockPos().offset(-2, -2, -2), (Vec3i)blockEntity.getBlockPos().offset(3, 3, 3)));
    }
}

