/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.tileentityrender;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.model.ModelNukeCrate;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.block.crate.BlockNukeCrate;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityNukeCrate;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityNukeCrateRenderer
implements BlockEntityRenderer<TileEntityNukeCrate> {
    public TileEntityNukeCrateRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityNukeCrate blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        VertexConsumer buffer;
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        Direction metadata = (Direction)blockEntity.getBlockState().getValue(BlockNukeCrate.FACING);
        switch (metadata) {
            case DOWN: {
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
                break;
            }
            case NORTH: {
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-90.0f));
            }
        }
        if (blockEntity.getBlockState().is(RRBlocks.nukeCrateBottom)) {
            buffer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.btnukebottom));
        } else if (blockEntity.getBlockState().is(RRBlocks.nukeCrateTop)) {
            buffer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.btnuketop));
        } else {
            throw new UnsupportedOperationException("Unknown block to render");
        }
        ModelNukeCrate.renderModelA(poseStack, buffer, packedLight, packedOverlay);
        ModelNukeCrate.renderModelB(poseStack, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.btcrate)), packedLight, packedOverlay);
        poseStack.popPose();
    }
}

