/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.client.tileentityrender;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.client.model.ObjModels;
import io.github.kadir1243.rivalrebels.common.block.machine.BlockReciever;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityReciever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityRecieverRenderer
implements BlockEntityRenderer<TileEntityReciever> {
    private final QuadCollection armModel;
    private final QuadCollection trayModel;
    private final QuadCollection adsdragonModel;

    public TileEntityRecieverRenderer(BlockEntityRendererProvider.Context context) {
        ModelManager modelManager = Minecraft.getInstance().getModelManager();
        this.armModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.ARM_MODEL);
        this.trayModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.TRAY_MODEL);
        this.adsdragonModel = (QuadCollection)modelManager.getStandaloneModel(ObjModels.ADS_DRAGON_MODEL);
    }

    public void render(TileEntityReciever blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        Direction facing = (Direction)blockEntity.getBlockState().getValue(BlockReciever.FACING);
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, 0.5);
        ObjModels.render(this.trayModel, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etreciever)), poseStack, -1, packedLight, packedOverlay);
        if (blockEntity.hasWeapon) {
            poseStack.translate(0.0, 0.75, -1.2600000000000002);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(blockEntity.yaw - facing.toYRot()));
            ObjModels.render(this.armModel, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etreciever)), poseStack, -1, packedLight, packedOverlay);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(blockEntity.pitch));
            ObjModels.render(this.adsdragonModel, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)RRIdentifiers.etadsdragon)), poseStack, -1, packedLight, packedOverlay);
        }
        poseStack.popPose();
        poseStack.popPose();
    }

    public int getViewDistance() {
        return 16384;
    }

    public AABB getRenderBoundingBox(TileEntityReciever blockEntity) {
        return AABB.of((BoundingBox)BoundingBox.fromCorners((Vec3i)blockEntity.getBlockPos().offset(-1, -1, -1), (Vec3i)blockEntity.getBlockPos().offset(2, 2, 2)));
    }
}

