/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.block.autobuilds;

import io.github.kadir1243.rivalrebels.common.core.BlackList;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.util.Translations;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.registries.DeferredBlock;

public abstract class BlockAutoTemplate
extends FallingBlock {
    public int time = 15;
    public String name = "building";

    public BlockAutoTemplate(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if (!stack.is(RRItems.pliers)) {
                player.displayClientMessage((Component)Translations.warning().append(" ").append((Component)Translations.USE_PLIERS_TO_BUILD_TRANSLATION.translate()), true);
                return InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void build(Level world, int x, int y, int z) {
        world.playLocalSound((double)x, (double)y, (double)z, (SoundEvent)RRSounds.AUTO_BUILD.get(), SoundSource.BLOCKS, 10.0f, 1.0f, false);
    }

    public void placeBlockCarefully(Level world, int x, int y, int z, Block block) {
        this.placeBlockCarefully(world, x, y, z, block.defaultBlockState());
    }

    public void placeBlockCarefully(Level world, int x, int y, int z, DeferredBlock<Block> block) {
        this.placeBlockCarefully(world, x, y, z, (Block)block.get());
    }

    public void placeBlockCarefully(Level world, int x, int y, int z, BlockState state) {
        this.placeBlockCarefully(world, new BlockPos(x, y, z), state);
    }

    public void placeBlockCarefully(Level world, BlockPos pos, Block block) {
        this.placeBlockCarefully(world, pos, block.defaultBlockState());
    }

    public void placeBlockCarefully(Level world, BlockPos pos, BlockState state) {
        if (!BlackList.autobuild(world.getBlockState(pos))) {
            world.setBlockAndUpdate(pos, state);
        }
    }

    public void onLand(Level world, BlockPos pos, BlockState fallingBlockState, BlockState currentStateInPos, FallingBlockEntity fallingBlockEntity) {
        if (!world.isClientSide()) {
            this.build(world, pos.getX(), pos.getY(), pos.getZ());
        }
    }

    public int getDustColor(BlockState state, BlockGetter level, BlockPos pos) {
        return -1;
    }
}

