/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.block.crate;

import io.github.kadir1243.rivalrebels.common.util.Translations;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractFlagBoxBlock
extends Block {
    public AbstractFlagBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public abstract ItemStack[] getItems();

    public abstract BlockState getStateToReplace();

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isShiftKeyDown() && !level.isClientSide()) {
            ItemStack[] items = this.getItems();
            NonNullList list = NonNullList.createWithCapacity((int)items.length);
            list.addAll(Arrays.asList(items));
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)list);
            level.destroyBlock(pos, false, (Entity)player);
            return InteractionResult.PASS;
        }
        if (!player.isShiftKeyDown() && !level.isClientSide()) {
            player.displayClientMessage((Component)Translations.orders().append(" ").append((Component)Translations.SHIFT_CLICK.translate()), false);
            level.setBlockAndUpdate(pos, this.getStateToReplace());
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }
}

