/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.block.crate;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockFlag
extends Block {
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    private static final VoxelShape UP_SHAPE = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> field_26659;
    String texpath = "rivalrebels:";

    public BlockFlag(BlockBehaviour.Properties settings, String name) {
        super(settings);
        this.texpath = this.texpath + name;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.field_26659 = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), BlockFlag::method_31018)));
    }

    private static VoxelShape method_31018(BlockState arg) {
        VoxelShape voxelshape = Shapes.empty();
        if (((Boolean)arg.getValue((Property)UP)).booleanValue()) {
            voxelshape = UP_SHAPE;
        }
        if (((Boolean)arg.getValue((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)arg.getValue((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)arg.getValue((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)WEST_SHAPE);
        }
        if (((Boolean)arg.getValue((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)EAST_SHAPE);
        }
        return voxelshape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, NORTH, EAST, SOUTH, WEST});
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return this.hasAdjacentBlocks(this.getPlacementShape(state, (BlockGetter)world, pos));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.field_26659.get(state);
    }

    private boolean shouldHaveSide(BlockGetter world, BlockPos pos, Direction side) {
        if (side == Direction.DOWN) {
            return false;
        }
        BlockPos blockpos = pos.relative(side);
        if (VineBlock.isAcceptableNeighbour((BlockGetter)world, (BlockPos)blockpos, (Direction)side)) {
            return true;
        }
        if (side.getAxis() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty booleanproperty = (BooleanProperty)VineBlock.PROPERTY_BY_DIRECTION.get(side);
        BlockState blockstate = world.getBlockState(pos.above());
        return blockstate.is((Block)this) && (Boolean)blockstate.getValue((Property)booleanproperty) != false;
    }

    private BlockState getPlacementShape(BlockState state, BlockGetter world, BlockPos pos) {
        BlockPos blockpos = pos.above();
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            state = (BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(VineBlock.isAcceptableNeighbour((BlockGetter)world, (BlockPos)blockpos, (Direction)Direction.DOWN)));
        }
        BlockState blockstate = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty = VineBlock.getPropertyForFace((Direction)direction);
            if (!((Boolean)state.getValue((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = this.shouldHaveSide(world, pos, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = world.getBlockState(blockpos);
                }
                flag = blockstate.is((Block)this) && (Boolean)blockstate.getValue((Property)booleanproperty) != false;
            }
            state = (BlockState)state.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
        }
        return state;
    }

    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (direction == Direction.DOWN) {
            return super.updateShape(state, world, tickAccess, pos, direction, neighborPos, neighborState, random);
        }
        BlockState blockstate = this.getPlacementShape(state, (BlockGetter)world, pos);
        return !this.hasAdjacentBlocks(blockstate) ? Blocks.AIR.defaultBlockState() : blockstate;
    }

    private boolean hasAdjacentBlocks(BlockState state) {
        return this.getAdjacentBlockCount(state) > 0;
    }

    private int getAdjacentBlockCount(BlockState state) {
        int i = 0;
        for (BooleanProperty booleanproperty : VineBlock.PROPERTY_BY_DIRECTION.values()) {
            if (!((Boolean)state.getValue((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockstate = ctx.getLevel().getBlockState(ctx.getClickedPos());
        boolean flag = blockstate.is((Block)this);
        BlockState blockstate1 = flag ? blockstate : this.defaultBlockState();
        for (Direction direction : ctx.getNearestLookingDirections()) {
            boolean flag1;
            if (direction == Direction.DOWN) continue;
            BooleanProperty booleanproperty = VineBlock.getPropertyForFace((Direction)direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.getValue((Property)booleanproperty) != false;
            if (flag1 || !this.shouldHaveSide((BlockGetter)ctx.getLevel(), ctx.getClickedPos(), direction)) continue;
            return (BlockState)blockstate1.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return flag ? blockstate1 : null;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)SOUTH)));
            }
        }
        return state;
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            }
        }
        return super.mirror(state, mirror);
    }
}

