/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.block.crate;

import com.mojang.serialization.MapCodec;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.block.trap.BlockAntimatterBomb;
import io.github.kadir1243.rivalrebels.common.block.trap.BlockNuclearBomb;
import io.github.kadir1243.rivalrebels.common.block.trap.BlockTachyonBomb;
import io.github.kadir1243.rivalrebels.common.block.trap.BlockTheoreticalTsarBomba;
import io.github.kadir1243.rivalrebels.common.block.trap.BlockTsarBomba;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityNukeCrate;
import io.github.kadir1243.rivalrebels.common.util.Translations;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BlockNukeCrate
extends BaseEntityBlock {
    public static final MapCodec<BlockNukeCrate> CODEC = BlockNukeCrate.simpleCodec(BlockNukeCrate::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;

    public BlockNukeCrate(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FACING, (Comparable)Direction.UP));
    }

    protected MapCodec<BlockNukeCrate> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public Direction determineOrientation(Level world, BlockPos pos) {
        Direction targetFacing;
        block3: {
            block2: {
                targetFacing = Direction.UP;
                if (this != RRBlocks.nukeCrateTop.get()) break block2;
                for (Direction facing : Direction.values()) {
                    BlockPos offset = pos.relative(facing);
                    if (!world.getBlockState(offset).is((Block)RRBlocks.nukeCrateBottom.get())) continue;
                    targetFacing = facing.getOpposite();
                }
                break block3;
            }
            if (this != RRBlocks.nukeCrateBottom.get()) break block3;
            for (Direction facing : Direction.values()) {
                BlockPos offset = pos.relative(facing);
                if (!world.getBlockState(offset).is(RRBlocks.nukeCrateTop)) continue;
                targetFacing = facing;
            }
        }
        return targetFacing;
    }

    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, @Nullable Orientation p_365159_, boolean p_60514_) {
        world.setBlockAndUpdate(pos, (BlockState)state.setValue(FACING, (Comparable)this.determineOrientation(world, pos)));
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        world.setBlockAndUpdate(pos, (BlockState)state.setValue(FACING, (Comparable)this.determineOrientation(world, pos)));
        for (Direction facing : Direction.values()) {
            BlockPos offset = pos.relative(facing);
            BlockState offsetState = world.getBlockState(offset);
            if (offsetState.is((Block)RRBlocks.nukeCrateBottom.get())) {
                this.neighborChanged(state, world, pos, (Block)this, null, true);
                continue;
            }
            if (!offsetState.getFluidState().is(FluidTags.LAVA)) continue;
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            world.explode(null, (double)x, (double)y, (double)z, 3.0f, Level.ExplosionInteraction.NONE);
        }
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this == RRBlocks.nukeCrateTop.get()) {
            if (!stack.isEmpty()) {
                if (stack.is(RRItems.pliers)) {
                    Direction orientation = null;
                    if (BlockNukeCrate.getBlock(level, pos.east()) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.below()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.below().east()) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.east(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below().east(), (BlockState)((Block)RRBlocks.antimatterbombblock.get()).defaultBlockState().setValue(BlockAntimatterBomb.FACING, (Comparable)Direction.WEST));
                        return InteractionResult.SUCCESS;
                    }
                    if (BlockNukeCrate.getBlock(level, pos.west()) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.below()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.below().west()) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.west(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below().west(), (BlockState)((Block)RRBlocks.antimatterbombblock.get()).defaultBlockState().setValue(BlockAntimatterBomb.FACING, (Comparable)Direction.EAST));
                        return InteractionResult.SUCCESS;
                    }
                    if (BlockNukeCrate.getBlock(level, pos.south()) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.below()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.below().south()) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.south(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below().south(), (BlockState)((Block)RRBlocks.antimatterbombblock.get()).defaultBlockState().setValue(BlockAntimatterBomb.FACING, (Comparable)Direction.NORTH));
                        return InteractionResult.SUCCESS;
                    }
                    if (BlockNukeCrate.getBlock(level, pos.north()) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.below()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.below().north()) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.north(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below().north(), (BlockState)((Block)RRBlocks.antimatterbombblock.get()).defaultBlockState().setValue(BlockAntimatterBomb.FACING, (Comparable)Direction.SOUTH));
                        return InteractionResult.SUCCESS;
                    }
                    if (BlockNukeCrate.getBlock(level, pos.east()) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.above()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.above().east()) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos.above(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above().east(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.east(), (BlockState)((Block)RRBlocks.tachyonbombblock.get()).defaultBlockState().setValue(BlockTachyonBomb.FACING, (Comparable)Direction.WEST));
                        return InteractionResult.SUCCESS;
                    }
                    if (BlockNukeCrate.getBlock(level, pos.west()) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.above()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.above().west()) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos.above(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above().west(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.west(), (BlockState)((Block)RRBlocks.tachyonbombblock.get()).defaultBlockState().setValue(BlockTachyonBomb.FACING, (Comparable)Direction.EAST));
                        return InteractionResult.SUCCESS;
                    }
                    if (BlockNukeCrate.getBlock(level, pos.south()) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.above()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.above().south()) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos.above(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above().south(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.south(), (BlockState)((Block)RRBlocks.tachyonbombblock.get()).defaultBlockState().setValue(BlockTachyonBomb.FACING, (Comparable)Direction.NORTH));
                        return InteractionResult.SUCCESS;
                    }
                    if (BlockNukeCrate.getBlock(level, pos.north()) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.above()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.above().north()) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos.above(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above().north(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.north(), (BlockState)((Block)RRBlocks.tachyonbombblock.get()).defaultBlockState().setValue(BlockTachyonBomb.FACING, (Comparable)Direction.SOUTH));
                        return InteractionResult.SUCCESS;
                    }
                    if (BlockNukeCrate.getBlock(level, pos.east()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.east(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.east(3)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.below()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.below().east()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.below().east(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.below().east(3)) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.east(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.east(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.east(3), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below().east(), (BlockState)((Block)RRBlocks.tsarbombablock.get()).defaultBlockState().setValue(BlockTsarBomba.FACING, (Comparable)Direction.WEST));
                        BlockNukeCrate.setBlock(level, pos.below().east(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below().east(3), Blocks.AIR);
                        return InteractionResult.SUCCESS;
                    }
                    if (BlockNukeCrate.getBlock(level, pos.west()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.west(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.west(3)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.below()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.below().west()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.below().west(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.below().west(3)) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.west(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.west(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.west(3), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below().west(), (BlockState)((Block)RRBlocks.tsarbombablock.get()).defaultBlockState().setValue(BlockTsarBomba.FACING, (Comparable)Direction.EAST));
                        BlockNukeCrate.setBlock(level, pos.below().west(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below().west(3), Blocks.AIR);
                        return InteractionResult.SUCCESS;
                    }
                    if (BlockNukeCrate.getBlock(level, pos.south()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.south(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.south(3)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.below()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.below().south()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.below().south(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.below().south(3)) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.south(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.south(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.south(3), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below().south(), (BlockState)((Block)RRBlocks.tsarbombablock.get()).defaultBlockState().setValue(BlockTsarBomba.FACING, (Comparable)Direction.NORTH));
                        BlockNukeCrate.setBlock(level, pos.below().south(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below().south(3), Blocks.AIR);
                        return InteractionResult.SUCCESS;
                    }
                    if (BlockNukeCrate.getBlock(level, pos.north()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.north(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.north(3)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.below()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.below().north()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.below().north(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.below().north(3)) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.north(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.north(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.north(3), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below().north(), (BlockState)((Block)RRBlocks.tsarbombablock.get()).defaultBlockState().setValue(BlockTsarBomba.FACING, (Comparable)Direction.SOUTH));
                        BlockNukeCrate.setBlock(level, pos.below().north(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.below().north(3), Blocks.AIR);
                        return InteractionResult.SUCCESS;
                    }
                    if (BlockNukeCrate.getBlock(level, pos.east()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.east(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.east(3)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.above()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.above().east()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.above().east(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.above().east(3)) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above().east(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.east(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.east(3), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.east(), (BlockState)((Block)RRBlocks.theoreticaltsarbombablock.get()).defaultBlockState().setValue(BlockTheoreticalTsarBomba.FACING, (Comparable)Direction.WEST));
                        BlockNukeCrate.setBlock(level, pos.above().east(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above().east(3), Blocks.AIR);
                        return InteractionResult.SUCCESS;
                    }
                    if (BlockNukeCrate.getBlock(level, pos.west()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.west(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.west(3)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.above()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.above().west()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.above().west(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.above().west(3)) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above().west(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.west(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.west(3), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.west(), (BlockState)((Block)RRBlocks.theoreticaltsarbombablock.get()).defaultBlockState().setValue(BlockTheoreticalTsarBomba.FACING, (Comparable)Direction.EAST));
                        BlockNukeCrate.setBlock(level, pos.above().west(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above().west(3), Blocks.AIR);
                        return InteractionResult.SUCCESS;
                    }
                    if (BlockNukeCrate.getBlock(level, pos.south()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.south(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.south(3)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.above()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.above().south()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.above().south(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.above().south(3)) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above().south(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.south(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.south(3), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.south(), (BlockState)((Block)RRBlocks.theoreticaltsarbombablock.get()).defaultBlockState().setValue(BlockTheoreticalTsarBomba.FACING, (Comparable)Direction.NORTH));
                        BlockNukeCrate.setBlock(level, pos.above().south(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above().south(3), Blocks.AIR);
                        return InteractionResult.SUCCESS;
                    }
                    if (BlockNukeCrate.getBlock(level, pos.north()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.north(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.north(3)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.above()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.above().north()) == RRBlocks.nukeCrateTop.get() && BlockNukeCrate.getBlock(level, pos.above().north(2)) == RRBlocks.nukeCrateBottom.get() && BlockNukeCrate.getBlock(level, pos.above().north(3)) == RRBlocks.nukeCrateBottom.get()) {
                        BlockNukeCrate.setBlock(level, pos, Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above().north(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.north(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.north(3), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above(), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.north(), (BlockState)((Block)RRBlocks.theoreticaltsarbombablock.get()).defaultBlockState().setValue(BlockTheoreticalTsarBomba.FACING, (Comparable)Direction.SOUTH));
                        BlockNukeCrate.setBlock(level, pos.above().north(2), Blocks.AIR);
                        BlockNukeCrate.setBlock(level, pos.above().north(3), Blocks.AIR);
                        return InteractionResult.SUCCESS;
                    }
                    for (Direction direction : Direction.values()) {
                        if (!level.getBlockState(pos.relative(direction.getOpposite())).is((Block)RRBlocks.nukeCrateBottom.get())) continue;
                        level.setBlockAndUpdate(pos.relative(direction.getOpposite()), Blocks.AIR.defaultBlockState());
                        orientation = direction;
                        break;
                    }
                    if (orientation == null) {
                        return InteractionResult.FAIL;
                    }
                    level.setBlockAndUpdate(pos, (BlockState)((Block)RRBlocks.nuclearBomb.get()).defaultBlockState().setValue(BlockNuclearBomb.FACING, orientation));
                    return InteractionResult.SUCCESS;
                }
                if (!level.isClientSide()) {
                    player.displayClientMessage((Component)Translations.orders().append(" ").append((Component)Component.translatable((String)"RivalRebels.message.use")).append(" ").append(((Item)RRItems.pliers.get()).getName()), false);
                }
            } else if (!level.isClientSide()) {
                player.displayClientMessage((Component)Translations.orders().append(" ").append((Component)Translations.USE_PLIERS_TO_BUILD_TRANSLATION.translate().withStyle(ChatFormatting.RED)), false);
            }
        }
        return InteractionResult.FAIL;
    }

    private static void setBlock(Level world, BlockPos pos, Block block) {
        world.setBlockAndUpdate(pos, block.defaultBlockState());
    }

    private static void setBlock(Level world, BlockPos pos, BlockState state) {
        world.setBlockAndUpdate(pos, state);
    }

    private static Block getBlock(Level world, BlockPos pos) {
        return world.getBlockState(pos).getBlock();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityNukeCrate(pos, state);
    }
}

