/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.block.trap;

import com.mojang.serialization.MapCodec;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskLeader;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskOfficer;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskRebel;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskRegular;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockLandMine
extends FallingBlock {
    public static final MapCodec<BlockLandMine> CODEC = BlockLandMine.simpleCodec(BlockLandMine::new);
    public static final BooleanProperty UNSTABLE = BlockStateProperties.UNSTABLE;

    public BlockLandMine(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)UNSTABLE, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UNSTABLE});
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)UNSTABLE)).booleanValue()) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            if (!world.isClientSide()) {
                world.explode(null, (double)pos.getX(), (double)((float)pos.getY() + 2.5f), (double)pos.getZ(), (float)RRConfig.SERVER.getLandmineExplodeSize(), Level.ExplosionInteraction.BLOCK);
            }
        }
    }

    public int getDustColor(BlockState state, BlockGetter level, BlockPos pos) {
        return -1;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        float f = 0.01f;
        return Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)(1.0f - f), (double)1.0);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier p_405359_) {
        if (entity instanceof Player || entity instanceof Mob || entity instanceof EntityRoddiskRegular || entity instanceof EntityRoddiskRebel || entity instanceof EntityRoddiskOfficer || entity instanceof EntityRoddiskLeader) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)UNSTABLE, (Comparable)Boolean.valueOf(true)));
            level.scheduleTick(pos, (Block)this, 5);
            entity.playSound((SoundEvent)RRSounds.LAND_MINE2.get(), 3.0f, 2.0f);
        }
    }

    protected void onExplosionHit(BlockState state, ServerLevel level, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> dropConsumer) {
        if (!level.isClientSide()) {
            level.explode(null, (double)pos.getX(), (double)((float)pos.getY() + 2.5f), (double)pos.getZ(), (float)RRConfig.SERVER.getLandmineExplodeSize(), Level.ExplosionInteraction.BLOCK);
        }
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        return RRBlocks.alandmine.toStack();
    }

    public void onLand(Level world, BlockPos pos, BlockState fallingBlockState, BlockState currentStateInPos, FallingBlockEntity fallingBlockEntity) {
        if (!world.isClientSide()) {
            world.explode(null, (double)pos.getX(), (double)((float)pos.getY() + 2.5f), (double)pos.getZ(), (float)RRConfig.SERVER.getLandmineExplodeSize(), Level.ExplosionInteraction.BLOCK);
        }
    }
}

