/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.block.trap;

import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockMario
extends Block {
    public BlockMario(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        float f = 0.0625f;
        return Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)(1.0f - f), (double)1.0);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier p_405359_) {
        if (entity instanceof Player || entity instanceof Mob) {
            level.setBlockAndUpdate(pos, Blocks.GRAVEL.defaultBlockState());
        }
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        BlockState[] n = (BlockState[])Arrays.stream(Direction.values()).map(arg_0 -> ((BlockPos)pos).relative(arg_0)).map(arg_0 -> ((Level)level).getBlockState(arg_0)).toArray(BlockState[]::new);
        int popularity1 = 0;
        int popularity2 = 0;
        BlockState mode = Blocks.GRAVEL.defaultBlockState();
        for (int i = 0; i < 6; ++i) {
            BlockState array_item = n[i];
            if (array_item.isAir() || !array_item.isSolid() || array_item.is(RRBlocks.landmine) || array_item.is(RRBlocks.alandmine) || array_item.is(RRBlocks.mario) || array_item.is(RRBlocks.amario) || array_item.is(RRBlocks.quicksand) || array_item.is(RRBlocks.aquicksand)) continue;
            for (BlockState blockState : n) {
                if (array_item == blockState) {
                    ++popularity1;
                }
                if (popularity1 < popularity2) continue;
                mode = array_item;
                popularity2 = popularity1;
            }
            popularity1 = 0;
        }
        if (mode.is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos, ((Block)RRBlocks.mario.get()).defaultBlockState(), 3);
        }
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        return RRBlocks.amario.toStack();
    }
}

