/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.block.trap;

import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockToxicGas
extends Block {
    public BlockToxicGas(BlockBehaviour.Properties settings) {
        super(settings);
        ((FireBlock)Blocks.FIRE).setFlammable((Block)this, 60, 100);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier p_405359_) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0));
            living.addEffect(new MobEffectInstance(MobEffects.NAUSEA, 200, 0));
            living.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 80, 0));
            living.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 80, 0));
        }
        if (entity instanceof PathfinderMob || entity instanceof Animal || entity instanceof Player) {
            entity.hurt(RivalRebelsDamageSource.gasGrenade(level), 1.0f);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        world.scheduleTick(pos, (Block)this, 8);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        world.scheduleTick(pos, (Block)this, 8);
        if (random.nextInt(25) == 1) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        Vec3 center = pos.getCenter();
        double x = center.x();
        double y = center.y();
        double z = center.z();
        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, ((double)random.nextFloat() - 0.5) * 0.1, ((double)random.nextFloat() - 0.5) * 0.1, ((double)random.nextFloat() - 0.5) * 0.1);
        world.addParticle((ParticleOptions)ParticleTypes.ENCHANT, x, y, z, ((double)random.nextFloat() - 0.5) * 0.1, ((double)random.nextFloat() - 0.5) * 0.1, ((double)random.nextFloat() - 0.5) * 0.1);
    }
}

