/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.container;

import io.github.kadir1243.rivalrebels.common.block.crate.BlockNukeCrate;
import io.github.kadir1243.rivalrebels.common.block.trap.BlockRemoteCharge;
import io.github.kadir1243.rivalrebels.common.container.SlotRR;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsGuiHandler;
import io.github.kadir1243.rivalrebels.common.item.ItemChip;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ContainerLaptop
extends AbstractContainerMenu {
    protected Container laptop;
    private final ContainerData containerData;

    public ContainerLaptop(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(14), (ContainerData)new SimpleContainerData(7));
    }

    public ContainerLaptop(int syncId, Inventory inventoryPlayer, Container laptop, ContainerData containerData) {
        super((MenuType)RivalRebelsGuiHandler.LAPTOP_SCREEN_HANDLER_TYPE.get(), syncId);
        this.laptop = laptop;
        this.containerData = containerData;
        this.addSlot(new SlotRR(laptop, 0, 80, 23, 1, ItemChip.class));
        this.addSlot(new SlotRR(laptop, 1, 50, 40, 1, ItemChip.class));
        this.addSlot(new SlotRR(laptop, 2, 111, 40, 1, ItemChip.class));
        this.addSlot(new SlotRR(laptop, 3, 80, 48, 1, ItemChip.class));
        this.addSlot(new SlotRR(laptop, 4, 26, 76, 1, BlockNukeCrate.class));
        this.addSlot(new SlotRR(laptop, 5, 44, 76, 1, BlockNukeCrate.class));
        this.addSlot(new SlotRR(laptop, 6, 62, 76, 1, (Holder<Item>)RRItems.NUCLEAR_ROD).setAcceptsTimedBomb(true));
        this.addSlot(new SlotRR(laptop, 7, 80, 76, 1, (Holder<Item>)RRItems.NUCLEAR_ROD).setAcceptsTimedBomb(true));
        this.addSlot(new SlotRR(laptop, 8, 98, 76, 1, (Holder<Item>)RRItems.NUCLEAR_ROD).setAcceptsTimedBomb(true));
        this.addSlot(new SlotRR(laptop, 9, 26, 94, 1, RRItems.antenna.asItem()));
        this.addSlot(new SlotRR(laptop, 10, 44, 94, 1, BlockRemoteCharge.class));
        this.addSlot(new SlotRR(laptop, 11, 62, 94, 1, (Holder<Item>)RRItems.hydrod).setAcceptsTimedBomb(true));
        this.addSlot(new SlotRR(laptop, 12, 80, 94, 1, (Holder<Item>)RRItems.hydrod).setAcceptsTimedBomb(true));
        this.addSlot(new SlotRR(laptop, 13, 98, 94, 1, (Holder<Item>)RRItems.hydrod).setAcceptsTimedBomb(true));
        this.bindPlayerInventory(inventoryPlayer);
        this.addDataSlots(containerData);
    }

    public boolean stillValid(Player player) {
        return this.laptop.stillValid(player);
    }

    protected void bindPlayerInventory(Inventory inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 119 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 175));
        }
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    public boolean isReady() {
        return this.containerData.get(0) == 1;
    }

    public boolean hasChips() {
        return this.containerData.get(1) == 1;
    }

    public int getB2spirit() {
        return this.containerData.get(2);
    }

    public int getB2carpet() {
        return this.containerData.get(3);
    }

    public BlockPos getLaptopPos() {
        return new BlockPos(this.containerData.get(4), this.containerData.get(5), this.containerData.get(6));
    }
}

