/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.container;

import io.github.kadir1243.rivalrebels.common.block.trap.BlockTimedBomb;
import io.github.kadir1243.rivalrebels.common.container.BombContainer;
import io.github.kadir1243.rivalrebels.common.container.SlotRR;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsGuiHandler;
import io.github.kadir1243.rivalrebels.common.item.ItemChip;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import net.minecraft.core.Holder;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ContainerNuclearBomb
extends AbstractContainerMenu
implements BombContainer {
    protected Container nuclearBomb;
    private final ContainerData containerData;

    public ContainerNuclearBomb(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(36), (ContainerData)new SimpleContainerData(5));
    }

    public ContainerNuclearBomb(int syncId, Inventory inventoryPlayer, Container nuclearBomb, ContainerData containerData) {
        super((MenuType)RivalRebelsGuiHandler.NUCLEAR_BOMB_SCREEN_HANDLER_TYPE.get(), syncId);
        this.nuclearBomb = nuclearBomb;
        this.containerData = containerData;
        this.addSlot(new SlotRR(nuclearBomb, 0, 16, 34, 1, (Holder<Item>)RRItems.fuse));
        for (int i = 0; i <= 4; ++i) {
            this.addSlot(new SlotRR(nuclearBomb, i + 1, 38 + i * 18, 25, 1, (Holder<Item>)RRItems.NUCLEAR_ROD).setAcceptsTrollface(true));
            this.addSlot(new SlotRR(nuclearBomb, i + 6, 38 + i * 18, 43, 1, (Holder<Item>)RRItems.NUCLEAR_ROD).setAcceptsTrollface(true));
        }
        this.addSlot(new SlotRR(nuclearBomb, 11, 133, 34, 1, BlockTimedBomb.class));
        this.addSlot(new SlotRR(nuclearBomb, 12, 152, 34, 1, ItemChip.class));
        this.bindPlayerInventory(inventoryPlayer);
        this.addDataSlots(containerData);
    }

    public boolean stillValid(Player player) {
        return this.nuclearBomb.stillValid(player);
    }

    protected void bindPlayerInventory(Inventory inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 139));
        }
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    @Override
    public int getCountdown() {
        return this.containerData.get(0);
    }

    public int getAmountOfCharges() {
        return this.containerData.get(1);
    }

    public boolean hasTrollFace() {
        return this.containerData.get(2) == 1;
    }

    public boolean isArmed() {
        return this.containerData.get(3) == 1 && this.containerData.get(4) == 1;
    }
}

