/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.container;

import io.github.kadir1243.rivalrebels.common.block.trap.BlockTimedBomb;
import io.github.kadir1243.rivalrebels.common.container.BombContainer;
import io.github.kadir1243.rivalrebels.common.container.SlotRR;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsGuiHandler;
import io.github.kadir1243.rivalrebels.common.item.ItemChip;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import net.minecraft.core.Holder;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ContainerTsar
extends AbstractContainerMenu
implements BombContainer {
    protected Container tsarBomb;
    private final ContainerData containerData;

    public ContainerTsar(int syncId, Inventory inv) {
        this(syncId, inv, (Container)new SimpleContainer(36), (ContainerData)new SimpleContainerData(4));
    }

    public ContainerTsar(int syncId, Inventory inventoryPlayer, Container tsarBomb, ContainerData containerData) {
        super((MenuType)RivalRebelsGuiHandler.TSAR_SCREEN_HANDLER_TYPE.get(), syncId);
        this.tsarBomb = tsarBomb;
        this.containerData = containerData;
        this.addSlot(new SlotRR(tsarBomb, 0, 18, 48, 1, (Holder<Item>)RRItems.fuse));
        this.addSlot(new SlotRR(tsarBomb, 1, 40, 59, 1, RRItems.antenna.asItem()));
        this.addSlot(new SlotRR(tsarBomb, 2, 40, 37, 1, RRItems.antenna.asItem()));
        for (int i = 0; i <= 3; ++i) {
            this.addSlot(new SlotRR(tsarBomb, i + 3, 62 + i * 18, 19, 1, (Holder<Item>)RRItems.NUCLEAR_ROD).setAcceptsTrollface(true));
            this.addSlot(new SlotRR(tsarBomb, i + 7, 62 + i * 18, 37, 1, (Holder<Item>)RRItems.NUCLEAR_ROD).setAcceptsTrollface(true));
            this.addSlot(new SlotRR(tsarBomb, i + 11, 62 + i * 18, 59, 1, (Holder<Item>)RRItems.hydrod).setAcceptsTrollface(true));
            this.addSlot(new SlotRR(tsarBomb, i + 15, 62 + i * 18, 77, 1, (Holder<Item>)RRItems.hydrod).setAcceptsTrollface(true));
        }
        this.addSlot(new SlotRR(tsarBomb, 19, 138, 48, 1, BlockTimedBomb.class));
        this.addSlot(new SlotRR(tsarBomb, 20, 98, 99, 1, ItemChip.class));
        this.bindPlayerInventory(inventoryPlayer);
        this.addDataSlots(containerData);
    }

    public boolean stillValid(Player player) {
        return this.tsarBomb.stillValid(player);
    }

    protected void bindPlayerInventory(Inventory inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 119 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 175));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            stack = slotItem.copy();
            if (index <= 19 ? !this.moveItemStackTo(slotItem, 19, this.slots.size(), true) : !this.moveItemStackTo(slotItem, 0, 19, false)) {
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }

    @Override
    public int getCountdown() {
        return this.containerData.get(0);
    }

    public boolean isUnbalanced() {
        return this.containerData.get(1) == 1;
    }

    public boolean isArmed() {
        return this.containerData.get(2) == 1;
    }

    public float getMegaton() {
        return (float)this.containerData.get(3) / 100.0f;
    }
}

