/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.core;

import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.util.ModBlockTags;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlackList {
    public static final Set<Predicate<BlockState>> explosion = BlackList.createSet((Block)RRBlocks.fshield.get(), (Block)RRBlocks.nuclearBomb.get(), (Block)RRBlocks.tsarbombablock.get(), (Block)RRBlocks.omegaobj.get(), (Block)RRBlocks.sigmaobj.get(), (Block)RRBlocks.forcefieldnode.get(), (Block)RRBlocks.reactor.get(), (Block)RRBlocks.loader.get(), (Block)RRBlocks.meltdown.get(), (Block)RRBlocks.forcefield.get(), (Block)RRBlocks.ffreciever.get());
    private static final Set<Predicate<BlockState>> tesla = new HashSet<Predicate>(Set.of(BlackList.of((Block)RRBlocks.omegaobj.get()), BlackList.of((Block)RRBlocks.sigmaobj.get()), BlackList.of((Block)RRBlocks.fshield.get()), BlackList.of(Blocks.BEDROCK), BlackList.of(Blocks.WATER), BlackList.of(Blocks.LAVA), BlackList.of(ModBlockTags.GLASS_BLOCKS), BlackList.of(Blocks.OBSIDIAN), BlackList.of(ModBlockTags.GLASS_PANES), BlackList.of((Block)RRBlocks.nuclearBomb.get()), BlackList.of((Block)RRBlocks.tsarbombablock.get()), BlackList.of((Block)RRBlocks.loader.get()), BlackList.of((Block)RRBlocks.reactor.get()), BlackList.of((Block)RRBlocks.forcefieldnode.get()), BlackList.of((Block)RRBlocks.conduit.get()), BlackList.of((Block)RRBlocks.forcefield.get()), BlackList.of((Block)RRBlocks.meltdown.get()), BlackList.of((Block)RRBlocks.ffreciever.get())));
    private static final Set<Predicate<BlockState>> plasmaExplosion = BlackList.createSet((Block)RRBlocks.omegaobj.get(), (Block)RRBlocks.sigmaobj.get(), (Block)RRBlocks.tsarbombablock.get(), (Block)RRBlocks.nuclearBomb.get(), (Block)RRBlocks.reactor.get(), (Block)RRBlocks.loader.get(), (Block)RRBlocks.controller.get(), (Block)RRBlocks.meltdown.get(), (Block)RRBlocks.forcefield.get(), (Block)RRBlocks.ffreciever.get());
    private static final Set<Predicate<BlockState>> autobuild = BlackList.createSet((Block)RRBlocks.fshield.get(), (Block)RRBlocks.nuclearBomb.get(), (Block)RRBlocks.tsarbombablock.get(), (Block)RRBlocks.omegaobj.get(), (Block)RRBlocks.sigmaobj.get(), (Block)RRBlocks.forcefieldnode.get(), (Block)RRBlocks.reactive.get(), (Block)RRBlocks.conduit.get(), (Block)RRBlocks.reactor.get(), (Block)RRBlocks.loader.get(), (Block)RRBlocks.meltdown.get(), (Block)RRBlocks.forcefield.get(), (Block)RRBlocks.ffreciever.get(), Blocks.BEDROCK);

    public static Predicate<BlockState> of(Block block) {
        return state -> state.is(block);
    }

    public static Predicate<BlockState> of(TagKey<Block> tag) {
        return state -> state.is(tag);
    }

    public static Set<Predicate<BlockState>> createSet(Block ... blocks) {
        return new HashSet<Predicate<BlockState>>(Arrays.stream(blocks).map(BlackList::of).toList());
    }

    public static boolean tesla(BlockState state) {
        return tesla.stream().anyMatch(value -> value.test(state));
    }

    public static boolean explosion(BlockState state) {
        return explosion.stream().anyMatch(value -> value.test(state));
    }

    public static boolean plasmaExplosion(BlockState state) {
        return plasmaExplosion.stream().anyMatch(value -> value.test(state));
    }

    public static boolean autobuild(BlockState state) {
        return autobuild.stream().anyMatch(value -> value.test(state));
    }
}

