/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.common.entity.EntityGore;
import io.github.kadir1243.rivalrebels.common.entity.EntityInanimate;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityBlood
extends EntityInanimate {
    private boolean isGore = true;

    public EntityBlood(EntityType<? extends EntityBlood> type, Level level) {
        super(type, level);
    }

    public EntityBlood(Level level) {
        this((EntityType<? extends EntityBlood>)((EntityType)RREntities.BLOOD.get()), level);
    }

    public EntityBlood(Level level, EntityGore bloodEmitter) {
        this(level);
        this.setPos(bloodEmitter.position());
        this.shoot(0.1f);
        this.isGore = true;
    }

    public EntityBlood(Level level, double x, double y, double z) {
        this(level);
        this.setPos(x, y, z);
        this.shoot(0.0f);
        this.isGore = false;
    }

    public void shoot(float force) {
        this.setDeltaMovement(this.random.nextGaussian() * (double)force, this.random.nextGaussian() * (double)force, this.random.nextGaussian() * (double)force);
    }

    public void tick() {
        super.tick();
        ++this.tickCount;
        if (this.isInWater() || this.tickCount == 20 && this.isGore) {
            this.kill((ServerLevel)this.level());
        }
        Vec3 vec3d = this.position().add(this.getDeltaMovement());
        this.setDeltaMovement(vec3d.x(), vec3d.y(), vec3d.z());
        this.setDeltaMovement(this.getDeltaMovement().scale((double)0.99f));
        this.push(0.0, -0.03f, 0.0);
        this.reapplyPosition();
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 256.0;
    }
}

