/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.common.entity.EntityGore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntityBloodFX
extends TextureSheetParticle {
    public EntityBloodFX(ClientLevel level, double x, double y, double z, boolean b) {
        this(level, x, y, z, level.random.nextGaussian() * 0.1, level.random.nextGaussian() * 0.1, level.random.nextGaussian() * 0.1, b);
    }

    public EntityBloodFX(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, boolean isBlood) {
        super(level, x, y, z, dx, dy, dz);
        this.setParticleSpeed(dx, dy, dz);
        this.gravity = 0.75f;
        this.lifetime = 20;
        this.setSprite((TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(isBlood ? RRIdentifiers.etblood : RRIdentifiers.etgoo));
    }

    public EntityBloodFX(ClientLevel level, EntityGore gore, boolean isBlood) {
        this(level, gore.getX(), gore.getY(), gore.getZ(), isBlood);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void renderParticle(PoseStack pose, VertexConsumer buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float f10 = 0.1f * this.quadSize;
        float f11 = (float)(this.xo + (this.x - this.xo) * (double)partialTicks);
        float f12 = (float)(this.yo + (this.y - this.yo) * (double)partialTicks);
        float f13 = (float)(this.zo + (this.z - this.zo) * (double)partialTicks);
        buffer.addVertex(pose.last(), f11 - rotationX * f10 - rotationXY * f10, f12 - rotationZ * f10, f13 - rotationYZ * f10 - rotationXZ * f10).setUv(1.0f, 1.0f).setColor(-1);
        buffer.addVertex(pose.last(), f11 - rotationX * f10 + rotationXY * f10, f12 + rotationZ * f10, f13 - rotationYZ * f10 + rotationXZ * f10).setUv(1.0f, 0.0f).setColor(-1);
        buffer.addVertex(pose.last(), f11 + rotationX * f10 + rotationXY * f10, f12 + rotationZ * f10, f13 + rotationYZ * f10 + rotationXZ * f10).setUv(0.0f, 0.0f).setColor(-1);
        buffer.addVertex(pose.last(), f11 + rotationX * f10 - rotationXY * f10, f12 - rotationZ * f10, f13 + rotationYZ * f10 - rotationXZ * f10).setUv(0.0f, 1.0f).setColor(-1);
    }
}

