/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityCuchillo
extends ThrowableProjectile {
    private boolean inGround;
    private int ticksInGround;

    public EntityCuchillo(EntityType<? extends EntityCuchillo> type, Level level) {
        super(type, level);
    }

    public EntityCuchillo(Level level) {
        this((EntityType<? extends EntityCuchillo>)((EntityType)RREntities.CUCHILLO.get()), level);
    }

    public EntityCuchillo(Level level, Entity player, float speed) {
        this(level);
        this.setOwner(player);
        this.snapTo(player.getEyePosition(), player.getYRot(), player.getXRot());
        this.setPos(this.getX() - (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f), this.getY() - (double)0.1f, this.getZ() - (double)(Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f));
        this.setDeltaMovement(-Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))) * speed, -Mth.sin((float)(this.getXRot() * ((float)Math.PI / 180))) * speed, Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))) * speed);
    }

    public EntityCuchillo(Level level, double mx, double my, double mz) {
        this(level);
        this.yRotO = (float)(Math.atan2(mx, mz) * 57.2957763671875);
        this.setYRot(this.yRotO);
        this.xRotO = (float)(Math.atan2(my, Math.sqrt(mx * mx + mz * mz)) * 57.2957763671875);
        this.setXRot(this.xRotO);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void onHitEntity(EntityHitResult result) {
        result.getEntity().hurt(RivalRebelsDamageSource.cuchillo(this.level()), 7.0f);
        this.kill((ServerLevel)this.level());
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        BlockPos pos = result.getBlockPos();
        BlockState state = this.level().getBlockState(pos);
        if (state.is(ModBlockTags.GLASS_BLOCKS) || state.is(ModBlockTags.GLASS_PANES)) {
            this.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            this.playSound((SoundEvent)RRSounds.CUCHILLO_GLASS_BREAK.get(), 5.0f, 0.3f);
        } else if (state.is(BlockTags.BASE_STONE_OVERWORLD)) {
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), RRItems.knife.toStack()));
            this.kill((ServerLevel)this.level());
        } else {
            this.inGround = true;
        }
    }

    public void tick() {
        super.tick();
        if (this.inGround) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            ++this.ticksInGround;
            if (this.ticksInGround == 60) {
                this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), RRItems.knife.toStack()));
                this.kill((ServerLevel)this.level());
            }
        }
    }

    protected void updateRotation() {
        Vec3 vec3 = this.getDeltaMovement();
        this.setXRot(this.getXRot() - 30.0f);
        this.setYRot(EntityCuchillo.lerpRotation((float)this.yRotO, (float)((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875))));
    }

    public void playerTouch(Player player) {
        if (!this.level().isClientSide() && this.inGround) {
            this.hitTargetOrDeflectSelf((HitResult)new EntityHitResult((Entity)player, this.position()));
            this.playSound(SoundEvents.LAVA_POP, 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.kill((ServerLevel)this.level());
        }
    }

    protected double getDefaultGravity() {
        return 0.026;
    }

    public boolean isAttackable() {
        return false;
    }
}

