/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityB2Spirit;
import io.github.kadir1243.rivalrebels.common.entity.EntityLightningLink;
import io.github.kadir1243.rivalrebels.common.entity.FlameBallProjectile;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityReciever;
import io.github.kadir1243.rivalrebels.common.util.ItemUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityFlameBall1
extends FlameBallProjectile {
    public EntityFlameBall1(EntityType<? extends EntityFlameBall1> type, Level level) {
        super(type, level);
    }

    public EntityFlameBall1(Level level) {
        this((EntityType<? extends EntityFlameBall1>)((EntityType)RREntities.FLAME_BALL1.get()), level);
    }

    public EntityFlameBall1(Level level, Entity entity, float speed) {
        this(level);
        this.setOwner(entity);
        this.setPos(entity.getEyePosition());
        this.setDeltaMovement(-Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(entity.getXRot() * ((float)Math.PI / 180))), -Mth.sin((float)(entity.getXRot() * ((float)Math.PI / 180))), Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(entity.getXRot() * ((float)Math.PI / 180))));
        this.setPosRaw(this.getX() - (double)(Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180))) * 0.2f), this.getY() - 0.13, this.getZ() - (double)(Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180))) * 0.2f));
        this.setDeltaMovement(this.getDeltaMovement().scale((double)speed));
    }

    public EntityFlameBall1(Level level, TileEntityReciever ter, float speed) {
        this(level);
        this.setYRot(180.0f - ter.yaw);
        this.setXRot(-ter.pitch);
        this.setPos((double)((float)ter.getBlockPos().getX() + ter.xO) + 0.5, (double)ter.getBlockPos().getY() + 0.75, (double)((float)ter.getBlockPos().getZ() + ter.zO) + 0.5);
        this.setDeltaMovement(-Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))), Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))), -Mth.sin((float)(this.getXRot() * ((float)Math.PI / 180))));
        this.setDeltaMovement(this.getDeltaMovement().scale((double)speed));
    }

    public void tick() {
        HitResult hitResult;
        super.tick();
        if (this.tickCount > 5) {
            ++this.sequence;
        }
        if (this.sequence > 15) {
            this.kill((ServerLevel)this.level());
        }
        if ((hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0))).getType() == HitResult.Type.ENTITY && this.tickCount >= 5) {
            this.fire();
            this.kill((ServerLevel)this.level());
            Entity entity = ((EntityHitResult)hitResult).getEntity();
            if (entity != null) {
                entity.igniteForSeconds(3.0f);
                entity.hurt(RivalRebelsDamageSource.cooked(this.level()), 12.0f);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    ItemUtil.damageRandomArmor((LivingEntity)player, 8, this.random);
                }
            } else {
                this.level().addFreshEntity((Entity)new EntityLightningLink(this.level(), (Entity)this, this.distanceTo(entity)));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    ItemUtil.damageRandomArmor((LivingEntity)player, 44, this.random);
                    player.hurt(RivalRebelsDamageSource.cooked(this.level()), (float)(250 / ((int)entity.distanceTo((Entity)this) + 1)));
                } else if (entity instanceof EntityB2Spirit) {
                    entity.hurt(RivalRebelsDamageSource.cooked(this.level()), (float)(250 / ((int)entity.distanceTo((Entity)this) + 1)));
                } else if (entity.isAttackable()) {
                    entity.hurt(RivalRebelsDamageSource.cooked(this.level()), (float)(250 / ((int)entity.distanceTo((Entity)this) + 1)));
                }
            }
        }
        this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        this.rotation += this.motionr;
        this.motionr *= 1.06f;
        if (this.isInWater()) {
            this.kill((ServerLevel)this.level());
        }
        float airFriction = 0.97f;
        this.setDeltaMovement(this.getDeltaMovement().scale((double)airFriction));
        this.applyGravity();
        this.reapplyPosition();
    }

    protected double getDefaultGravity() {
        return 0.01f;
    }

    private void fire() {
        if (!this.level().isClientSide()) {
            for (int x = -1; x < 2; ++x) {
                for (int y = -1; y < 2; ++y) {
                    for (int z = -1; z < 2; ++z) {
                        BlockPos pos = this.blockPosition().offset(x, y, z);
                        BlockState state = this.level().getBlockState(pos);
                        Block id = state.getBlock();
                        if (state.isAir() || state.is(BlockTags.SNOW) || state.is(BlockTags.ICE)) {
                            this.level().setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                            continue;
                        }
                        if (state.is(BlockTags.LEAVES)) {
                            this.level().setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                            continue;
                        }
                        if (id == Blocks.GRASS_BLOCK && this.random.nextInt(5) == 0) {
                            this.level().setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
                            continue;
                        }
                        if (!state.is(RRBlocks.flare)) continue;
                        id.destroy((LevelAccessor)this.level(), pos, state);
                    }
                }
            }
        }
    }
}

