/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.FlameBallProjectile;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityReciever;
import io.github.kadir1243.rivalrebels.common.util.ItemUtil;
import io.github.kadir1243.rivalrebels.common.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityFlameBall2
extends FlameBallProjectile {
    public boolean gonnadie;

    public EntityFlameBall2(EntityType<? extends EntityFlameBall2> type, Level level) {
        super(type, level);
    }

    public EntityFlameBall2(Level level) {
        this((EntityType<? extends EntityFlameBall2>)((EntityType)RREntities.FLAME_BALL2.get()), level);
    }

    public EntityFlameBall2(Level level, Entity entity, float speed) {
        this(level);
        this.setPos(entity.getEyePosition());
        this.setDeltaMovement(-Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(entity.getXRot() * ((float)Math.PI / 180))), -Mth.sin((float)(entity.getXRot() * ((float)Math.PI / 180))), Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(entity.getXRot() * ((float)Math.PI / 180))));
        this.setPosRaw(this.getX() - (double)(Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180))) * 0.2f), this.getY() - 0.13, this.getZ() - (double)(Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180))) * 0.2f));
        this.setDeltaMovement(this.getDeltaMovement().scale((double)speed));
    }

    public EntityFlameBall2(Level level, TileEntityReciever ter, float speed) {
        this(level);
        this.setYRot(180.0f - ter.yaw);
        this.setXRot(-ter.pitch);
        this.setPos((double)((float)ter.getBlockPos().getX() + ter.xO) + 0.5, (double)ter.getBlockPos().getY() + 0.5, (double)((float)ter.getBlockPos().getZ() + ter.zO) + 0.5);
        this.setDeltaMovement(-Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))), Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))), -Mth.sin((float)(this.getXRot() * ((float)Math.PI / 180))));
        this.setDeltaMovement(this.getDeltaMovement().scale((double)speed));
    }

    public void tick() {
        HitResult hitResult;
        super.tick();
        ++this.sequence;
        if (this.sequence > 15) {
            this.kill((ServerLevel)this.level());
        }
        if (this.tickCount > 5 && this.random.nextDouble() > 0.5) {
            this.gonnadie = true;
        }
        if (this.gonnadie && this.sequence < 15) {
            ++this.sequence;
        }
        if ((hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0))).getType() != HitResult.Type.MISS && this.tickCount >= 6) {
            this.setPosRaw(this.getX() - 0.5, this.getY() - 0.5, this.getZ() - 0.5);
            this.fire();
            this.setPosRaw(this.getX() + 1.0, this.getY(), this.getZ());
            this.fire();
            this.setPosRaw(this.getX() - 2.0, this.getY(), this.getZ());
            this.fire();
            this.setPosRaw(this.getX() + 1.0, this.getY() + 1.0, this.getZ());
            this.fire();
            this.setPosRaw(this.getX(), this.getY() - 2.0, this.getZ());
            this.fire();
            this.setPosRaw(this.getX(), this.getY() + 1.0, this.getZ() + 1.0);
            this.fire();
            this.setPosRaw(this.getX(), this.getY(), this.getZ() - 2.0);
            this.fire();
            this.setPosRaw(this.getX(), this.getY(), this.getZ() + 1.0);
            this.setPosRaw(this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5);
            this.kill((ServerLevel)this.level());
            if (hitResult.getType() == HitResult.Type.ENTITY) {
                Entity entityHit = ((EntityHitResult)hitResult).getEntity();
                entityHit.igniteForSeconds(3.0f);
                entityHit.hurt(RivalRebelsDamageSource.cooked(this.level()), 12.0f);
                if (entityHit instanceof Player) {
                    Player player = (Player)entityHit;
                    ItemUtil.damageRandomArmor((LivingEntity)player, 8, this.random);
                }
            }
        }
        this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        this.rotation += this.motionr;
        this.motionr *= 1.06f;
        if (this.isInWater()) {
            this.kill((ServerLevel)this.level());
        }
        float airFriction = 0.9f;
        if (this.gonnadie) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.05, 0.0));
            airFriction = 0.7f;
        }
        this.setDeltaMovement(this.getDeltaMovement().scale((double)airFriction));
        this.reapplyPosition();
    }

    private void fire() {
        if (!this.level().isClientSide()) {
            BlockState state = this.level().getBlockState(this.blockPosition());
            Block id = state.getBlock();
            if (state.isAir() || state.is(BlockTags.SNOW) || state.is(BlockTags.ICE)) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.FIRE.defaultBlockState());
            } else if (state.is(BlockTags.SAND) && this.random.nextInt(60) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.GLASS.defaultBlockState());
            } else if (state.is(ModBlockTags.GLASS_BLOCKS) && this.random.nextInt(120) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.OBSIDIAN.defaultBlockState());
            } else if (state.is(Blocks.OBSIDIAN) && this.random.nextInt(90) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.LAVA.defaultBlockState());
            } else if ((state.is(BlockTags.BASE_STONE_OVERWORLD) || state.is(Blocks.COBBLESTONE)) && this.random.nextInt(30) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.LAVA.defaultBlockState());
            } else if (state.is(BlockTags.IRON_ORES) && this.random.nextInt(30) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.LAVA.defaultBlockState());
            } else if (state.is(BlockTags.COAL_ORES) && this.random.nextInt(30) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.LAVA.defaultBlockState());
            } else if (state.is(BlockTags.GOLD_ORES) && this.random.nextInt(30) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.LAVA.defaultBlockState());
            } else if (state.is(BlockTags.LAPIS_ORES) && this.random.nextInt(30) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.LAVA.defaultBlockState());
            } else if (state.is(Blocks.GRAVEL) && this.random.nextInt(30) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.LAVA.defaultBlockState());
            } else if (state.is(ModBlockTags.SANDSTONE_BLOCKS) && this.random.nextInt(30) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.LAVA.defaultBlockState());
            } else if (state.is(Blocks.IRON_BLOCK) && this.random.nextInt(50) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.LAVA.defaultBlockState());
            } else if (state.is(Blocks.BEDROCK) && this.random.nextInt(500) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.OBSIDIAN.defaultBlockState());
            } else if (state.getFluidState().is(FluidTags.LAVA)) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.AIR.defaultBlockState());
            } else if (state.is(BlockTags.LEAVES)) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.FIRE.defaultBlockState());
            } else if (state.is(BlockTags.DIRT)) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.FIRE.defaultBlockState());
            } else if (state.is(RRBlocks.flare)) {
                id.destroy((LevelAccessor)this.level(), this.blockPosition(), state);
            } else if (state.is(RRBlocks.timedbomb)) {
                id.destroy((LevelAccessor)this.level(), this.blockPosition(), state);
            } else if (state.is(RRBlocks.remotecharge)) {
                id.destroy((LevelAccessor)this.level(), this.blockPosition(), state);
            } else if (state.is(RRBlocks.landmine)) {
                id.destroy((LevelAccessor)this.level(), this.blockPosition(), state);
            } else if (state.is(RRBlocks.alandmine)) {
                id.destroy((LevelAccessor)this.level(), this.blockPosition(), state);
            } else if (state.is(Blocks.TNT)) {
                TntBlock.prime((Level)this.level(), (BlockPos)this.blockPosition());
                this.level().removeBlock(this.blockPosition(), false);
            } else if (state.is(RRBlocks.conduit)) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.FIRE.defaultBlockState());
            } else if (state.is(RRBlocks.reactive) && this.random.nextInt(20) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.LAVA.defaultBlockState());
            } else if ((state.is(RRBlocks.camo1) || state.is(RRBlocks.camo2) || state.is(RRBlocks.camo3)) && this.random.nextInt(40) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), ((Block)RRBlocks.steel.get()).defaultBlockState());
            } else if (state.is(RRBlocks.steel) && this.random.nextInt(40) == 0) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.FIRE.defaultBlockState());
            }
        }
    }
}

