/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.common.entity.EntityGore;
import io.github.kadir1243.rivalrebels.common.entity.EntityInanimate;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityGoo
extends EntityInanimate {
    private boolean isGore = true;

    public EntityGoo(EntityType<? extends EntityGoo> type, Level world) {
        super(type, world);
    }

    public EntityGoo(Level level) {
        this((EntityType<? extends EntityGoo>)((EntityType)RREntities.GOO.get()), level);
    }

    public EntityGoo(Level level, EntityGore bloodEmitter) {
        this(level);
        this.snapTo(bloodEmitter.getX(), bloodEmitter.getY(), bloodEmitter.getZ(), 0.0f, 0.0f);
        this.shoot(0.1f);
        this.isGore = true;
    }

    public EntityGoo(Level level, double x, double y, double z) {
        this(level);
        this.snapTo(x, y, z, 0.0f, 0.0f);
        this.shoot(0.0f);
        this.isGore = false;
    }

    public void shoot(float force) {
        this.setDeltaMovement(this.random.nextGaussian() * (double)force, this.random.nextGaussian() * (double)force, this.random.nextGaussian() * (double)force);
    }

    public void tick() {
        super.tick();
        ++this.tickCount;
        Vec3 vec31 = this.position().add(this.getDeltaMovement());
        if (this.isInWater() || this.tickCount == 20 && this.isGore) {
            this.kill((ServerLevel)this.level());
        }
        this.setPosRaw(vec31.x(), vec31.y(), vec31.z());
        this.setDeltaMovement(this.getDeltaMovement().scale((double)0.99f));
        this.push(0.0, -0.03f, 0.0);
        this.reapplyPosition();
    }

    public boolean shouldRenderAtSqrDistance(double range) {
        return range < 256.0;
    }
}

