/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.entity.EntityBloodFX;
import io.github.kadir1243.rivalrebels.common.entity.EntityInanimate;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class EntityGore
extends EntityInanimate {
    public static final EntityDataAccessor<Integer> MOB = SynchedEntityData.defineId(EntityGore.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> TYPE_OF_GORE = SynchedEntityData.defineId(EntityGore.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> SIZE = SynchedEntityData.defineId(EntityGore.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> IS_GREEN = SynchedEntityData.defineId(EntityGore.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Optional<EntityReference<LivingEntity>>> OWNER = SynchedEntityData.defineId(EntityGore.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_LIVING_ENTITY_REFERENCE);
    protected boolean inGround;
    public Entity origin;
    private boolean isSliding = false;
    private int slideCount = 0;
    float x = 0.0f;
    float y = 0.0f;
    float z = 0.0f;
    float rotYaw = 0.0f;
    float rotPitch = 0.0f;
    float motionyaw = 0.0f;
    float motionpitch = 0.0f;
    int pitchLock = 0;
    float offset = 0.0f;
    public ResourceLocation playerSkin = null;
    private int bounces = -1;

    public EntityGore(EntityType<? extends EntityGore> type, Level world) {
        super(type, world);
    }

    public EntityGore(Level level) {
        this((EntityType<? extends EntityGore>)((EntityType)RREntities.GORE.get()), level);
    }

    public EntityGore(Level level, double mx, double my, double mz, int Type2, int Mob2) {
        this(level);
        this.yRotO = (float)(Mth.atan2((double)mx, (double)mz) * 57.2957763671875);
        this.setYRot(this.yRotO);
        this.xRotO = (float)(Math.atan2(my, Math.sqrt(mx * mx + mz * mz)) * 57.2957763671875);
        this.setXRot(this.xRotO);
        this.setTypeOfGore(Type2);
        this.setMob(Mob2);
    }

    public void setMob(int mob) {
        this.entityData.set(MOB, (Object)mob);
    }

    public int getMob() {
        return (Integer)this.entityData.get(MOB);
    }

    public boolean isGreen() {
        return (Boolean)this.entityData.get(IS_GREEN);
    }

    public void setGreen(boolean green) {
        this.entityData.set(IS_GREEN, (Object)green);
    }

    public EntityGore(Level level, Entity toBeGibbed, int Type2, int mob) {
        this(level);
        this.origin = toBeGibbed;
        this.isSliding = false;
        this.slideCount = 0;
        this.bounces = -1;
        this.pitchLock = 0;
        this.setTypeOfGore(Type2);
        this.setGreen(false);
        this.setMob(mob);
        if (mob == 0) {
            Player player;
            Entity entity = this.origin;
            this.setOwner((LivingEntity)(entity instanceof Player ? (player = (Player)entity) : null));
            this.setBiped(0);
        } else if (mob == 1) {
            this.setBiped(0);
        } else if (mob == 2) {
            this.setBiped(0);
        } else if (mob == 3) {
            this.setBiped(1);
            this.setGreen(true);
        } else if (mob == 4) {
            this.setBiped(2);
        } else if (mob == 5) {
            this.setQuadruped();
            this.setGreen(true);
        } else if (mob == 6) {
            this.setNoped();
            this.setGreen(true);
        } else if (mob == 7) {
            this.setNoped();
        } else if (mob == 8) {
            this.setOctoped(0);
        } else if (mob == 9) {
            this.setOctoped(1);
            this.setGreen(true);
        } else if (mob == 10) {
            this.setOctoped(2);
        } else if (mob == 11) {
            this.setSize((float)this.origin.getBoundingBox().getSize());
            if (this.getSize() > 2.0f || this.getSize() < 1.0f) {
                this.setGreen(true);
            }
            this.setDefault();
        }
        this.motionyaw = (float)((this.random.nextDouble() - 0.5) * 135.0);
        this.motionpitch = (float)((this.random.nextDouble() - 0.5) * 135.0);
        this.snapTo(toBeGibbed.getX() + (double)this.x, toBeGibbed.getY() + (double)this.y, toBeGibbed.getZ() + (double)this.z, this.rotYaw, this.rotPitch);
        this.shoot(0.3f);
    }

    private void setNoped() {
        if (this.getTypeOfGore() == 0) {
            this.y = this.origin.getEyeHeight(this.origin.getPose());
            this.offset = 0.5f;
        } else if (this.getTypeOfGore() == 1) {
            this.y = this.origin.getEyeHeight(this.origin.getPose());
            this.offset = 0.25f;
        }
        this.rotYaw = this.origin.getYRot();
    }

    public int getTypeOfGore() {
        return (Integer)this.entityData.get(TYPE_OF_GORE);
    }

    public void setTypeOfGore(int type) {
        this.entityData.set(TYPE_OF_GORE, (Object)type);
    }

    private void setBiped(int thin) {
        if (this.getTypeOfGore() == 0) {
            this.y = this.origin.getEyeHeight(this.origin.getPose()) + 0.2f;
            this.offset = 0.25f;
            this.rotYaw = this.origin.getYRot();
            this.rotPitch = this.origin.getXRot();
        } else if (this.getTypeOfGore() == 1) {
            this.y = thin == 2 ? 2.0f : 1.1f;
            this.offset = 0.125f;
            this.rotYaw = this.origin.getYRot();
        } else if (this.getTypeOfGore() == 2) {
            this.x = (float)this.random.nextDouble() - 0.5f;
            this.y = thin == 2 ? 1.6f : 1.1f;
            this.z = (float)this.random.nextDouble() - 0.5f;
            this.offset = thin == 0 ? 0.125f : 0.0625f;
            this.rotYaw = this.origin.getYRot();
        } else if (this.getTypeOfGore() == 3) {
            this.x = (float)this.random.nextDouble() - 0.5f;
            this.y = thin == 2 ? 0.95f : 0.35f;
            this.z = (float)this.random.nextDouble() - 0.5f;
            this.offset = thin == 0 ? 0.125f : 0.0625f;
            this.rotYaw = this.origin.getYRot();
        }
    }

    private void setQuadruped() {
        if (this.getTypeOfGore() == 0) {
            this.y = this.origin.getEyeHeight(this.origin.getPose());
            this.offset = 0.25f;
            this.rotYaw = this.origin.getYRot();
            this.rotPitch = this.origin.getXRot();
        } else if (this.getTypeOfGore() == 1) {
            this.y = 0.875f;
            this.offset = 0.125f;
            this.rotYaw = this.origin.getYRot();
        } else if (this.getTypeOfGore() == 3) {
            this.x = (float)(this.random.nextDouble() - 0.5);
            this.y = 0.25f;
            this.z = (float)(this.random.nextDouble() - 0.5);
            this.offset = 0.125f;
            this.rotYaw = this.origin.getYRot();
        }
    }

    private void setOctoped(int mode) {
        if (mode != 2) {
            float scale = 1.0f;
            if (mode == 1) {
                scale = 0.666f;
            }
            if (this.getTypeOfGore() == 0) {
                this.y = this.origin.getEyeHeight(this.origin.getPose());
                this.offset = 0.25f * scale;
                this.rotYaw = this.origin.getYRot();
                this.rotPitch = this.origin.getXRot();
            } else if (this.getTypeOfGore() == 1) {
                this.x = (float)(this.random.nextDouble() - 0.5) * scale;
                this.y = 0.25f * scale;
                this.z = (float)(this.random.nextDouble() - 0.5) * scale;
                this.offset = 0.1f * scale;
                this.rotYaw = this.origin.getYRot();
            } else if (this.getTypeOfGore() == 3) {
                this.x = (float)(this.random.nextDouble() - 0.5) * scale;
                this.y = 0.25f * scale;
                this.z = (float)(this.random.nextDouble() - 0.5) * scale;
                this.offset = 0.0625f * scale;
                this.rotYaw = (float)(this.random.nextDouble() * 360.0);
                this.rotPitch = 25.0f;
            }
        } else if (this.getTypeOfGore() == 0) {
            this.y = this.origin.getEyeHeight(this.origin.getPose());
            this.offset = 1.5f;
            this.rotYaw = this.origin.getYRot();
            this.rotPitch = this.origin.getXRot();
        } else if (this.getTypeOfGore() == 3) {
            this.x = (float)(this.random.nextDouble() - 0.5) * 4.0f;
            this.z = (float)(this.random.nextDouble() - 0.5) * 4.0f;
            this.offset = 0.125f;
        }
    }

    private void setDefault() {
        if (this.getTypeOfGore() == 0) {
            this.y = this.origin.getEyeHeight(this.origin.getPose()) + 0.2f;
            this.offset = 0.25f;
            this.rotYaw = this.origin.getYRot();
            this.rotPitch = this.origin.getXRot();
        } else if (this.getTypeOfGore() == 1) {
            this.y = this.origin.getEyeHeight(this.origin.getPose()) / 2.0f;
            this.offset = 0.125f;
            this.rotYaw = this.origin.getYRot();
        } else if (this.getTypeOfGore() == 2) {
            this.x = (float)((this.random.nextDouble() - 0.5) * (double)this.getSize());
            this.y = this.origin.getEyeHeight(this.origin.getPose()) / 2.0f;
            this.z = (float)((this.random.nextDouble() - 0.5) * (double)this.getSize());
            this.offset = 0.0625f;
            this.rotYaw = this.origin.getYRot();
        } else if (this.getTypeOfGore() == 3) {
            this.x = (float)((this.random.nextDouble() - 0.5) * (double)this.getSize());
            this.y = this.origin.getEyeHeight(this.origin.getPose()) / 4.0f;
            this.z = (float)((this.random.nextDouble() - 0.5) * (double)this.getSize());
            this.offset = 0.0625f;
            this.rotYaw = this.origin.getYRot();
        }
    }

    public float getSize() {
        return ((Float)this.entityData.get(SIZE)).floatValue();
    }

    public void setSize(float size) {
        this.entityData.set(SIZE, (Object)Float.valueOf(size));
    }

    public void shoot(float par7) {
        this.setDeltaMovement(this.random.nextGaussian() * (double)par7, Mth.abs((float)((float)(this.random.nextGaussian() * (double)par7))), this.random.nextGaussian() * (double)par7);
    }

    public EntityReference<LivingEntity> getOwner() {
        return ((Optional)this.entityData.get(OWNER)).orElse(null);
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.entityData.set(OWNER, Optional.ofNullable(owner).map(EntityReference::new));
    }

    public void tick() {
        if (this.playerSkin == null && this.level().isClientSide() && this.getOwner() != null) {
            for (Player player : this.level().players()) {
                if (!this.getOwner().matches((UniquelyIdentifyable)player)) continue;
                AbstractClientPlayer acp = (AbstractClientPlayer)player;
                this.playerSkin = acp.getSkin().texture();
            }
        }
        ++this.tickCount;
        super.tick();
        if (this.inGround) {
            this.inGround = false;
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f)));
        }
        if (this.isSliding) {
            ++this.slideCount;
            if (this.slideCount == 140) {
                this.kill((ServerLevel)this.level());
            }
        }
        Vec3 vec3 = this.position();
        Vec3 vec31 = this.position().add(this.getDeltaMovement());
        BlockHitResult hitResult = this.level().clip(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (hitResult != null) {
            this.isSliding = true;
            this.setPosRaw(this.getX(), hitResult.getLocation().y() + (double)this.offset, this.getZ());
        }
        this.setXRot(this.getXRot() + this.motionpitch);
        this.setYRot(this.getYRot() + this.motionyaw);
        this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        this.setXRot(this.xRotO + (this.getXRot() - this.xRotO) * 0.5f);
        this.setYRot(this.yRotO + (this.getYRot() - this.yRotO) * 0.5f);
        float f2 = 0.99f;
        if (this.isInWater()) {
            for (int k = 0; k < 4; ++k) {
                float f4 = 0.25f;
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - this.getDeltaMovement().x() * (double)f4, this.getY() - this.getDeltaMovement().y() * (double)f4, this.getZ() - this.getDeltaMovement().z() * (double)f4, this.getDeltaMovement().x(), this.getDeltaMovement().y(), this.getDeltaMovement().z());
            }
            f2 = 0.9f;
        } else if (!this.isSliding) {
            if (this.level().isClientSide() && RRConfig.CLIENT.isGoreEnabled()) {
                this.spawnBlood();
            }
        } else {
            f2 = 0.8f;
        }
        this.motionpitch = (float)((double)this.motionpitch * (double)f2);
        this.motionyaw = (float)((double)this.motionyaw * (double)f2);
        this.setDeltaMovement(this.getDeltaMovement().scale((double)f2));
        this.applyGravity();
        if (this.isSliding) {
            if (this.bounces == -1) {
                this.bounces = this.random.nextInt(2) + 2;
            }
            if (this.bounces > 0) {
                --this.bounces;
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -(this.random.nextDouble() * 0.5 + 0.35), 1.0));
                this.isSliding = false;
                this.slideCount = 0;
                this.pitchLock = Mth.ceil((float)(this.getXRot() / 90.0f)) * 90;
            } else {
                this.setDeltaMovement(this.getDeltaMovement().x(), 0.0, this.getDeltaMovement().z());
            }
            this.motionpitch = 0.0f;
            this.setXRot(this.pitchLock);
        }
        this.reapplyPosition();
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnBlood() {
        for (int i = 0; i < 3; ++i) {
            Minecraft.getInstance().particleEngine.add((Particle)new EntityBloodFX((ClientLevel)this.level(), this, !this.isGreen()));
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        valueOutput.putInt("Mob", this.getMob());
        valueOutput.putInt("TypeOfGore", this.getTypeOfGore());
        valueOutput.putBoolean("Green", this.isGreen());
        if (this.getOwner() != null) {
            this.getOwner().store(valueOutput, "owner");
        }
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueInput) {
        this.setMob((Integer)valueInput.getInt("Mob").orElseThrow());
        this.setTypeOfGore((Integer)valueInput.getInt("TypeOfGore").orElseThrow());
        this.setGreen(valueInput.getBooleanOr("Green", false));
        if (valueInput.child("owner").isPresent()) {
            EntityReference owner = EntityReference.readWithOldOwnerConversion((ValueInput)valueInput, (String)"owner", (Level)this.level());
            this.entityData.set(OWNER, Optional.ofNullable(owner));
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(MOB, (Object)-1);
        builder.define(TYPE_OF_GORE, (Object)0);
        builder.define(SIZE, (Object)Float.valueOf(0.0f));
        builder.define(IS_GREEN, (Object)false);
        builder.define(OWNER, Optional.empty());
    }
}

