/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.entity.EntityPropulsionFX;
import io.github.kadir1243.rivalrebels.common.entity.EntityTsarBlast;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.explosion.NuclearExplosion;
import io.github.kadir1243.rivalrebels.common.util.ModBlockTags;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityHackB83
extends ThrowableProjectile {
    public int ticksInAir = 0;
    private Vec3 mmPos = Vec3.ZERO;
    boolean straight;

    public EntityHackB83(EntityType<? extends EntityHackB83> entityType, Level world) {
        super(entityType, world);
    }

    public EntityHackB83(Level level) {
        this((EntityType<? extends EntityHackB83>)((EntityType)RREntities.HACK_B83.get()), level);
    }

    public EntityHackB83(Level level, double x, double y, double z, float yaw, float pitch, boolean flystraight) {
        this(level);
        this.straight = flystraight;
        this.snapTo(x, y, z, yaw, pitch);
        this.setDeltaMovement(-(-Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)))), -Mth.sin((float)(pitch * ((float)Math.PI / 180))), Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180))));
    }

    public EntityHackB83(Level level, double mx, double my, double mz, boolean flystraight) {
        this(level);
        this.yRotO = (float)(Math.atan2(mx, mz) * 57.2957763671875);
        this.setYRot(this.yRotO);
        this.xRotO = (float)(Math.atan2(my, Math.sqrt(mx * mx + mz * mz)) * 57.2957763671875);
        this.setXRot(this.xRotO);
        this.straight = flystraight;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        HitResult hitResult;
        if (this.ticksInAir == -100 || this.getY() < (double)this.level().getMinY() || this.getY() > (double)this.level().getMaxY()) {
            this.explode();
        }
        ++this.ticksInAir;
        if (!this.straight && !this.level().isClientSide()) {
            this.mmPos = this.mmPos.add(this.random.nextGaussian() * 0.4, this.random.nextGaussian() * 0.4, this.random.nextGaussian() * 0.4);
            this.mmPos = this.mmPos.normalize();
            if (this.ticksInAir > 35) {
                this.setDeltaMovement(this.getDeltaMovement().add(this.mmPos.scale(0.2)));
            } else {
                this.setDeltaMovement(this.getDeltaMovement().add(this.mmPos.x() * (double)0.2f, (double)(Mth.abs((float)((float)this.mmPos.y())) * 0.2f), this.mmPos.z() * (double)0.2f));
            }
        }
        if (this.level().isClientSide() && !this.isInWater()) {
            this.level().addFreshEntity((Entity)new EntityPropulsionFX(this.level(), this.getX(), this.getY(), this.getZ(), -this.getDeltaMovement().x(), -this.getDeltaMovement().y(), -this.getDeltaMovement().z()));
            this.level().addFreshEntity((Entity)new EntityPropulsionFX(this.level(), this.getX(), this.getY(), this.getZ(), -this.getDeltaMovement().x() * (double)0.8f, -this.getDeltaMovement().y() * (double)0.8f, -this.getDeltaMovement().z() * (double)0.8f));
            this.level().addFreshEntity((Entity)new EntityPropulsionFX(this.level(), this.getX(), this.getY(), this.getZ(), -this.getDeltaMovement().x() * (double)0.6f, -this.getDeltaMovement().y() * (double)0.6f, -this.getDeltaMovement().z() * (double)0.6f));
            this.level().addFreshEntity((Entity)new EntityPropulsionFX(this.level(), this.getX(), this.getY(), this.getZ(), -this.getDeltaMovement().x() * (double)0.4f, -this.getDeltaMovement().y() * (double)0.4f, -this.getDeltaMovement().z() * (double)0.4f));
            this.level().addFreshEntity((Entity)new EntityPropulsionFX(this.level(), this.getX(), this.getY(), this.getZ(), -this.getDeltaMovement().x() * (double)0.2f, -this.getDeltaMovement().y() * (double)0.2f, -this.getDeltaMovement().z() * (double)0.2f));
        }
        if ((hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0))).getType() != HitResult.Type.MISS) {
            this.onHit(hitResult);
        }
        this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        this.updateRotation();
        float var17 = 0.9f;
        if (!this.straight && !this.level().isClientSide()) {
            this.setDeltaMovement(this.getDeltaMovement().scale((double)var17));
        }
        this.reapplyPosition();
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        BlockState state = this.level().getBlockState(blockHitResult.getBlockPos());
        MapColor color = state.getMapColor((BlockGetter)this.level(), blockHitResult.getBlockPos());
        if (state.is(BlockTags.LEAVES) || color == MapColor.COLOR_GREEN || color == MapColor.DIRT || state.is(BlockTags.FLOWERS) || state.is(BlockTags.CROPS) || state.is(Blocks.CAKE) || state.getBlock().getExplosionResistance() < 1.0f || state.is(BlockTags.WOOL) || state.is(Blocks.SNOW_BLOCK) || state.is(ModBlockTags.GLASS_BLOCKS) || state.is(BlockTags.SAND) || state.is(BlockTags.SNOW) || state.ignitedByLava() || state.canBeReplaced() || state.getFluidState().is(FluidTags.WATER) || state.is(Blocks.SPONGE) || state.is(BlockTags.ICE)) {
            this.level().setBlockAndUpdate(blockHitResult.getBlockPos(), Blocks.AIR.defaultBlockState());
            return;
        }
        this.explode();
    }

    public void explode() {
        if (this.level().isClientSide()) {
            return;
        }
        new NuclearExplosion(this.level(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), RRConfig.SERVER.getB83Strength(), false);
        this.level().addFreshEntity((Entity)new EntityTsarBlast(this.level(), this.getX(), this.getY(), this.getZ(), (float)RRConfig.SERVER.getB83Strength() * 1.3333334f).setTime());
        this.kill((ServerLevel)this.level());
    }
}

