/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.command.CommandHotPotato;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.entity.EntityTsarBlast;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.explosion.TsarBomba;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityHotPotato
extends ThrowableProjectile {
    public int round = 0;
    public int nextx = 0;
    public int nexty = 0;
    public int nextz = 0;
    public boolean dorounds = false;
    public int charges = RRConfig.SERVER.getTsarBombaStrength() + 9;

    public EntityHotPotato(EntityType<? extends EntityHotPotato> type, Level world) {
        super(type, world);
    }

    public EntityHotPotato(Level level) {
        this((EntityType<? extends EntityHotPotato>)((EntityType)RREntities.HOT_POTATO.get()), level);
    }

    public EntityHotPotato(Level level, int x, int y, int z, int count) {
        this(level);
        this.setPos((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
        this.round = count;
        this.nextx = x;
        this.nexty = y;
        this.nextz = z;
        this.dorounds = true;
    }

    public EntityHotPotato(Level world, double px, double py, double pz) {
        this(world);
        this.round = 1;
        this.nextx = (int)px;
        this.nexty = (int)py;
        this.nextz = (int)pz;
        this.tickCount = 1;
        this.dorounds = true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        if (this.tickCount == -100) {
            this.explode();
        }
        ++this.tickCount;
        if (this.tickCount < 2 && this.dorounds) {
            this.playSound((SoundEvent)RRSounds.NUKE.get(), 100.0f, 1.0f);
            this.setDeltaMovement(Vec3.ZERO);
            this.setPos((float)this.nextx + 0.5f, (float)this.nexty + 0.5f, (float)this.nextz + 0.5f);
            this.level().setBlockAndUpdate(new BlockPos(this.nextx, this.nexty - 400, this.nextz), ((Block)RRBlocks.jump.get()).defaultBlockState());
            this.reapplyPosition();
            return;
        }
        if (!this.level().isClientSide()) {
            HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
            if (hitResult.getType() != HitResult.Type.MISS) {
                this.onHit(hitResult);
            }
            if (this.level().getBlockState(this.blockPosition()).getFluidState().is(FluidTags.WATER)) {
                this.setDeltaMovement(this.getDeltaMovement().x(), this.getDeltaMovement().y() + (double)0.06f, this.getDeltaMovement().z());
            }
        }
        this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        if (this.getY() < (double)this.level().getMinY()) {
            this.kill((ServerLevel)this.level());
        }
        if (this.isPassenger()) {
            float var16 = (float)this.getDeltaMovement().horizontalDistance();
            this.setYRot((float)(Math.atan2(this.getDeltaMovement().x(), this.getDeltaMovement().z()) * 57.2957763671875));
            this.setXRot((float)(Math.atan2(this.getDeltaMovement().y(), var16) * 57.2957763671875));
            while (this.getXRot() - this.xRotO < -180.0f) {
                this.xRotO -= 360.0f;
            }
            while (this.getXRot() - this.xRotO >= 180.0f) {
                this.xRotO += 360.0f;
            }
            while (this.getYRot() - this.yRotO < -180.0f) {
                this.yRotO -= 360.0f;
            }
            while (this.getYRot() - this.yRotO >= 180.0f) {
                this.yRotO += 360.0f;
            }
            this.setXRot(this.xRotO + (this.getXRot() - this.xRotO) * 0.05f);
            this.setYRot(this.yRotO + (this.getYRot() - this.yRotO) * 0.05f);
        }
        float var17 = 0.98f;
        this.setDeltaMovement(this.getDeltaMovement().scale((double)var17));
        this.applyGravity();
        this.reapplyPosition();
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putInt("charge", this.charges);
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.charges = valueInput.getIntOr("charge", 0);
        if (this.charges == 0) {
            this.charges = RRConfig.SERVER.getTsarBombaStrength() + 9;
        }
        this.yRotO = valueInput.getFloatOr("rot", 0.0f);
        this.setYRot(this.yRotO);
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        BlockState state = this.level().getBlockState(blockHitResult.getBlockPos());
        if (state.is(RRBlocks.jump) || state.is(BlockTags.ICE)) {
            this.setDeltaMovement(this.getDeltaMovement().x(), Math.max(-this.getDeltaMovement().y(), (double)0.2f), this.getDeltaMovement().z());
            return;
        }
        if (this.random.nextInt(10) != 0) {
            this.setDeltaMovement(this.getDeltaMovement().x(), Math.max(-this.getDeltaMovement().y(), (double)0.2f), this.getDeltaMovement().z());
            return;
        }
        this.explode();
    }

    public void explode() {
        if (!this.level().isClientSide()) {
            TsarBomba tsar = new TsarBomba((int)this.getX(), (int)this.getY(), (int)this.getZ(), this.level(), this.charges);
            EntityTsarBlast tsarblast = new EntityTsarBlast(this.level(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), tsar, this.charges);
            this.level().addFreshEntity((Entity)tsarblast);
            this.tickCount = 0;
            --this.round;
            CommandHotPotato.roundinprogress = false;
            if (this.round <= 0) {
                this.kill((ServerLevel)this.level());
            }
        }
    }
}

