/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityGore;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodesHead;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodesLeftLowerArm;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodesLeftLowerLeg;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodesLeftUpperArm;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodesLeftUpperLeg;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodesRightLowerArm;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodesRightLowerLeg;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodesRightUpperArm;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodesRightUpperLeg;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodesTorso;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.util.ItemUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityLaserBurst
extends Projectile {
    public EntityLaserBurst(EntityType<? extends EntityLaserBurst> type, Level world) {
        super(type, world);
    }

    public EntityLaserBurst(Level level) {
        this((EntityType<? extends EntityLaserBurst>)((EntityType)RREntities.LASER_BURST.get()), level);
    }

    public EntityLaserBurst(Level level, Entity player) {
        this(level);
        this.setOwner(player);
        this.snapTo(player.getX() - (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.2f), player.getEyeY() - 0.12, player.getZ() - (double)(Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.2f), player.getYRot(), player.getXRot());
        this.shootFromRotation(player, player.getXRot(), player.getYRot(), 0.0f, 4.0f, 0.075f);
    }

    public EntityLaserBurst(Level level, Entity player, boolean accurate) {
        this(level);
        this.setOwner(player);
        this.snapTo(player.getX() - (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.2f), player.getEyeY() - 0.12, player.getZ() - (double)(Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.2f), player.getYRot(), player.getXRot());
        this.shootFromRotation(player, player.getXRot(), player.getYRot(), 0.0f, 4.0f * (float)this.random.nextDouble() + 1.0f, accurate ? 0.001f : 0.075f);
    }

    public EntityLaserBurst(Level level, double mx, double my, double mz) {
        this(level);
        this.yRotO = (float)(Math.atan2(mx, mz) * 57.2957763671875);
        this.setYRot(this.yRotO);
        this.xRotO = (float)(Math.atan2(my, Math.sqrt(mx * mx + mz * mz)) * 57.2957763671875);
        this.setXRot(this.xRotO);
    }

    public EntityLaserBurst(Level level, double x, double y, double z, double mx, double my, double mz, Entity player) {
        this(level);
        this.setOwner(player);
        this.setPos(x, y, z);
        this.setDeltaMovement(mx, my, mz);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        HitResult hitResult;
        super.tick();
        ++this.tickCount;
        if (this.tickCount > 60) {
            this.kill((ServerLevel)this.level());
        }
        if ((hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0))).getType() != HitResult.Type.MISS) {
            this.onHit(hitResult);
        }
        this.setPos(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        this.updateRotation();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        BlockPos pos = result.getBlockPos();
        BlockState state = this.level().getBlockState(pos);
        if (state.is(Blocks.TNT)) {
            if (!this.level().isClientSide()) {
                LivingEntity entity;
                Entity entity2;
                PrimedTnt tnt = new PrimedTnt(this.level(), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (entity2 = this.getOwner()) instanceof LivingEntity ? (entity = (LivingEntity)entity2) : null);
                tnt.setFuse(this.random.nextInt(tnt.getFuse() / 4) + tnt.getFuse() / 8);
                this.level().addFreshEntity((Entity)tnt);
                this.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            }
        } else if (state.is(RRBlocks.remotecharge)) {
            state.onExplosionHit((ServerLevel)this.level(), pos, null, (stack, pos1) -> {});
        } else if (state.is(RRBlocks.timedbomb)) {
            state.onExplosionHit((ServerLevel)this.level(), pos, null, (stack, pos1) -> {});
        }
        this.kill((ServerLevel)this.level());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onHitEntity(EntityHitResult result) {
        Entity hitEntity = result.getEntity();
        if (hitEntity instanceof Player) {
            Player player = (Player)hitEntity;
            ItemUtil.damageRandomArmor((LivingEntity)player, 24, this.random);
            player.hurt(RivalRebelsDamageSource.laserBurst(this.level()), 16.0f);
            if (player.getHealth() < 3.0f && player.isAlive()) {
                player.hurt(RivalRebelsDamageSource.laserBurst(this.level()), 2000000.0f);
                player.deathTime = 0;
                this.level().addFreshEntity((Entity)new EntityGore(this.level(), hitEntity, 0, 0));
                this.level().addFreshEntity((Entity)new EntityGore(this.level(), hitEntity, 1, 0));
                this.level().addFreshEntity((Entity)new EntityGore(this.level(), hitEntity, 2, 0));
                this.level().addFreshEntity((Entity)new EntityGore(this.level(), hitEntity, 2, 0));
                this.level().addFreshEntity((Entity)new EntityGore(this.level(), hitEntity, 3, 0));
                this.level().addFreshEntity((Entity)new EntityGore(this.level(), hitEntity, 3, 0));
            }
            this.kill((ServerLevel)this.level());
            return;
        }
        if (hitEntity instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)hitEntity;
            if (!(hitEntity instanceof Animal || hitEntity instanceof Bat || hitEntity instanceof Villager || hitEntity instanceof Squid)) {
                entity.hurt(RivalRebelsDamageSource.laserBurst(this.level()), 6.0f);
                if (entity.getHealth() < 3.0f) {
                    int i;
                    int arms;
                    int legs;
                    entity.kill((ServerLevel)this.level());
                    this.playSound((SoundEvent)RRSounds.BLASTER_FIRE.get(), 1.0f, 4.0f);
                    LivingEntity livingEntity = entity;
                    Objects.requireNonNull(livingEntity);
                    LivingEntity livingEntity2 = livingEntity;
                    int n = 0;
                    int mobs = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ZombifiedPiglin.class, Zombie.class, Skeleton.class, EnderMan.class, Creeper.class, MagmaCube.class, Slime.class, CaveSpider.class, Spider.class, Ghast.class}, (Object)livingEntity2, n)) {
                        case 0 -> {
                            ZombifiedPiglin ignored = (ZombifiedPiglin)livingEntity2;
                            legs = 2;
                            arms = 2;
                            yield 2;
                        }
                        case 1 -> {
                            Zombie ignored = (Zombie)livingEntity2;
                            legs = 2;
                            arms = 2;
                            yield 1;
                        }
                        case 2 -> {
                            Skeleton ignored = (Skeleton)livingEntity2;
                            legs = 2;
                            arms = 2;
                            yield 3;
                        }
                        case 3 -> {
                            EnderMan ignored = (EnderMan)livingEntity2;
                            legs = 2;
                            arms = 2;
                            yield 4;
                        }
                        case 4 -> {
                            Creeper ignored = (Creeper)livingEntity2;
                            legs = 4;
                            arms = 0;
                            yield 5;
                        }
                        case 5 -> {
                            MagmaCube ignored = (MagmaCube)livingEntity2;
                            legs = 0;
                            arms = 0;
                            yield 7;
                        }
                        case 6 -> {
                            Slime ignored = (Slime)livingEntity2;
                            legs = 0;
                            arms = 0;
                            yield 6;
                        }
                        case 7 -> {
                            CaveSpider ignored = (CaveSpider)livingEntity2;
                            legs = 8;
                            arms = 0;
                            yield 9;
                        }
                        case 8 -> {
                            Spider ignored = (Spider)livingEntity2;
                            legs = 8;
                            arms = 0;
                            yield 8;
                        }
                        case 9 -> {
                            Ghast ignored = (Ghast)livingEntity2;
                            legs = 9;
                            arms = 0;
                            yield 10;
                        }
                        default -> {
                            legs = (int)(entity.getBoundingBox().getSize() * 2.0);
                            arms = (int)(entity.getBoundingBox().getSize() * 2.0);
                            yield 11;
                        }
                    };
                    this.level().addFreshEntity((Entity)new EntityGore(this.level(), hitEntity, 0, mobs));
                    this.level().addFreshEntity((Entity)new EntityGore(this.level(), hitEntity, 1, mobs));
                    for (i = 0; i < arms; ++i) {
                        this.level().addFreshEntity((Entity)new EntityGore(this.level(), hitEntity, 2, mobs));
                    }
                    for (i = 0; i < legs; ++i) {
                        this.level().addFreshEntity((Entity)new EntityGore(this.level(), hitEntity, 3, mobs));
                    }
                }
                this.kill((ServerLevel)this.level());
                return;
            }
        }
        if (!(hitEntity instanceof EntityRhodesHead || hitEntity instanceof EntityRhodesLeftLowerArm || hitEntity instanceof EntityRhodesLeftLowerLeg || hitEntity instanceof EntityRhodesLeftUpperArm || hitEntity instanceof EntityRhodesLeftUpperLeg || hitEntity instanceof EntityRhodesRightLowerArm || hitEntity instanceof EntityRhodesRightLowerLeg || hitEntity instanceof EntityRhodesRightUpperArm || hitEntity instanceof EntityRhodesRightUpperLeg)) {
            if (!(hitEntity instanceof EntityRhodesTorso)) return;
        }
        hitEntity.hurt(RivalRebelsDamageSource.laserBurst(this.level()), 6.0f);
    }
}

