/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityInanimate;
import io.github.kadir1243.rivalrebels.common.entity.EntityTsarBlast;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.explosion.NuclearExplosion;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityNuclearBlast
extends EntityInanimate {
    int time;
    int Strength;

    public EntityNuclearBlast(EntityType<? extends EntityNuclearBlast> type, Level world) {
        super(type, world);
    }

    public EntityNuclearBlast(Level level) {
        this((EntityType<? extends EntityNuclearBlast>)((EntityType)RREntities.NUCLEAR_BLAST.get()), level);
        this.tickCount = 0;
        this.time = 0;
    }

    public EntityNuclearBlast(Level level, double x, double y, double z, int s, boolean hasTroll) {
        this(level);
        this.Strength = s;
        this.setDeltaMovement(hasTroll ? 1.0 : 0.0, this.Strength, this.getDeltaMovement().z());
        this.setPos(x, y, z);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.tickCount == 0) {
                this.level().explode(null, this.getX(), this.getY() - 5.0, this.getZ(), 4.0f, Level.ExplosionInteraction.BLOCK);
            }
            if (this.tickCount % 20 == 0 && this.tickCount > 60) {
                ++this.time;
                if (this.time <= this.Strength) {
                    new NuclearExplosion(this.level(), (int)this.getX(), (int)this.getY() - 5, (int)this.getZ(), this.time * this.time / 2 + RRConfig.SERVER.getNuclearBombStrength());
                }
            }
            if (this.tickCount % 2 == 0 && this.tickCount < 400) {
                this.pushAndHurtEntities();
            }
        }
        if (this.tickCount < 30) {
            this.level().playLocalSound(this.getX(), this.getY() + (double)this.tickCount - 5.0, this.getZ(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), this.getSoundSource(), 4.0f, this.random.nextFloat() * 0.1f + 0.9f, true);
        }
        if (this.tickCount % 3 == 0 && this.tickCount < 40 && this.tickCount > 30) {
            for (int i = 0; i < 21; ++i) {
                this.level().playLocalSound(this.getX() + (double)Mth.sin((float)i) * ((double)i / 0.5), this.getY() + 17.0, this.getZ() + (double)Mth.cos((float)i) * ((double)i / 0.5), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), this.getSoundSource(), 4.0f, this.random.nextFloat() + 1.0f, true);
            }
        }
        if (this.tickCount < 600) {
            if (this.tickCount % 5 == this.random.nextInt(5)) {
                for (Player p : this.level().players()) {
                    p.playSound(SoundEvents.LIGHTNING_BOLT_THUNDER, 10.0f, 0.5f);
                    p.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 5.0f, 0.1f);
                }
            }
        } else {
            this.kill((ServerLevel)this.level());
        }
        ++this.tickCount;
    }

    private void pushAndHurtEntities() {
        int radius = this.Strength * RRConfig.SERVER.getNuclearBombStrength();
        if (radius > 80) {
            radius = 80;
        }
        AABB aabb = new AABB(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ()).inflate((double)(radius + 1), (double)(-(radius + 1)), (double)(radius + 1));
        List var9 = this.level().getEntities((Entity)this, aabb);
        for (Entity entity : var9) {
            Vec3 vec3;
            double var13 = Math.sqrt(entity.distanceToSqr(this.getX(), this.getY(), this.getZ())) / (double)radius;
            if (!(var13 <= 1.0) || (vec3 = entity.getEyePosition().subtract(this.position())).length() == 0.0) continue;
            vec3 = vec3.normalize();
            if (entity instanceof EntityNuclearBlast || entity instanceof EntityTsarBlast) continue;
            if (entity instanceof FallingBlockEntity) {
                entity.kill((ServerLevel)this.level());
                continue;
            }
            if (entity instanceof Player && entity.isInvulnerable()) continue;
            entity.hurt(RivalRebelsDamageSource.nuclearBlast(this.level()), (float)(16 * radius));
            entity.setDeltaMovement(this.getDeltaMovement().subtract(vec3.scale(8.0)));
        }
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueInput) {
        this.tickCount = valueInput.getIntOr("age", 0);
        this.time = valueInput.getIntOr("time", 0);
        this.Strength = valueInput.getIntOr("charges", 0);
        this.setDeltaMovement(valueInput.getBooleanOr("troll", false) ? 1.0 : 0.0, this.Strength, this.getDeltaMovement().z());
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        valueOutput.putInt("age", this.tickCount);
        valueOutput.putInt("time", this.time);
        valueOutput.putInt("charges", this.Strength);
    }
}

