/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.entity.EntityNuclearBlast;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.util.ModBlockTags;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityNuke
extends ThrowableProjectile {
    public int ticksInAir = 0;
    public int aoc = 0;
    public boolean troll = false;

    public EntityNuke(EntityType<? extends EntityNuke> type, Level world) {
        super(type, world);
    }

    public EntityNuke(Level level) {
        this((EntityType<? extends EntityNuke>)((EntityType)RREntities.NUKE.get()), level);
    }

    public EntityNuke(Level level, double x, double y, double z, float yaw, float pitch, int charges, boolean troll) {
        this(level);
        this.snapTo(x, y, z, yaw, pitch);
        this.yRotO = yaw;
        this.setYRot(this.yRotO);
        this.xRotO = pitch;
        this.setXRot(this.xRotO);
        this.aoc = charges;
        this.troll = troll;
        if (!RRConfig.SERVER.isNukedrop()) {
            this.explode();
        }
    }

    public EntityNuke(Level level, double mx, double my, double mz) {
        this(level);
        this.aoc = 1;
        this.setDeltaMovement(mx, my, mz);
        this.yRotO = (float)(Math.atan2(mx, mz) * 57.2957763671875);
        this.setYRot(this.yRotO);
        this.xRotO = (float)(Math.atan2(my, Math.sqrt(mx * mx + mz * mz)) * 57.2957763671875);
        this.setXRot(this.xRotO);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        if (!this.level().isClientSide()) {
            if (this.ticksInAir == -100) {
                this.explode();
            }
            ++this.ticksInAir;
            HitResult var3 = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
            if (var3.getType() != HitResult.Type.MISS) {
                this.onHit(var3);
            }
        }
        this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        if (this.getY() < (double)this.level().getMinY()) {
            this.kill((ServerLevel)this.level());
        }
        if (this.isPassenger()) {
            float var16 = (float)this.getDeltaMovement().horizontalDistance();
            this.setYRot((float)(Math.atan2(this.getDeltaMovement().x(), this.getDeltaMovement().z()) * 57.2957763671875));
            this.setXRot((float)(Math.atan2(this.getDeltaMovement().y(), var16) * 57.2957763671875));
            while (this.getXRot() - this.xRotO < -180.0f) {
                this.xRotO -= 360.0f;
            }
            while (this.getXRot() - this.xRotO >= 180.0f) {
                this.xRotO += 360.0f;
            }
            while (this.getYRot() - this.yRotO < -180.0f) {
                this.yRotO -= 360.0f;
            }
            while (this.getYRot() - this.yRotO >= 180.0f) {
                this.yRotO += 360.0f;
            }
            this.setXRot(this.xRotO + (this.getXRot() - this.xRotO) * 0.05f);
            this.setYRot(this.yRotO + (this.getYRot() - this.yRotO) * 0.05f);
        }
        float var17 = 0.98f;
        this.setDeltaMovement(this.getDeltaMovement().scale((double)var17));
        this.applyGravity();
        this.reapplyPosition();
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putInt("charge", this.aoc);
        valueOutput.putBoolean("troll", this.troll);
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.aoc = valueInput.getIntOr("charge", 0);
        this.troll = valueInput.getBooleanOr("troll", false);
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        BlockState state = this.level().getBlockState(blockHitResult.getBlockPos());
        MapColor color = state.getMapColor((BlockGetter)this.level(), blockHitResult.getBlockPos());
        if (state.is(RRBlocks.jump) || state.is(BlockTags.ICE)) {
            this.setDeltaMovement(this.getDeltaMovement().x(), Math.max(-this.getDeltaMovement().y(), (double)0.2f), this.getDeltaMovement().z());
        } else if (state.is(BlockTags.LEAVES) || color == MapColor.COLOR_GREEN || color == MapColor.DIRT || state.is(BlockTags.FLOWERS) || state.is(BlockTags.CROPS) || state.is(Blocks.CAKE) || state.getBlock().getExplosionResistance() < 1.0f || state.is(BlockTags.WOOL) || state.is(Blocks.SNOW_BLOCK) || state.is(ModBlockTags.GLASS_BLOCKS) || state.is(BlockTags.SAND) || state.is(BlockTags.SNOW) || state.ignitedByLava() || state.canBeReplaced() || state.getFluidState().is(FluidTags.WATER) || state.is(Blocks.SPONGE) || state.is(BlockTags.ICE)) {
            this.level().setBlockAndUpdate(blockHitResult.getBlockPos(), Blocks.AIR.defaultBlockState());
        }
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        this.explode();
    }

    public void explode() {
        if (!this.level().isClientSide()) {
            this.level().addFreshEntity((Entity)new EntityNuclearBlast(this.level(), this.getX(), this.getY(), this.getZ(), this.aoc, this.troll));
            this.kill((ServerLevel)this.level());
        }
    }
}

