/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class EntityPassiveFire
extends Projectile {
    private int ticksInAir;
    private double damage;

    public EntityPassiveFire(EntityType<? extends EntityPassiveFire> type, Level world) {
        super(type, world);
    }

    public EntityPassiveFire(Level level) {
        this((EntityType<? extends EntityPassiveFire>)((EntityType)RREntities.PASSIVE_FIRE.get()), level);
        this.ticksInAir = 0;
        this.damage = 2.0;
    }

    public EntityPassiveFire(Level level, double x, double y, double z) {
        this(level);
        this.setPos(x, y, z);
    }

    public EntityPassiveFire(Level level, Entity entity, float par3) {
        this(level);
        this.setOwner(entity);
        this.snapTo(entity.getEyePosition(), entity.getYRot(), entity.getXRot());
        this.setYRot((this.getYRot() + 25.0f) % 360.0f);
        this.setPos(this.getX() - (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f), this.getY() - 0.2, this.getZ() - (double)(Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f));
        super.setDeltaMovement((double)(-Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180)))), (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180)))), (double)(-Mth.sin((float)(this.getXRot() * ((float)Math.PI / 180)))));
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance <= 16.0;
    }

    public EntityPassiveFire(Level world, int x, int y, int z, int mx, int my, int mz) {
        this(world);
        this.setPos(x, y, z);
        super.setDeltaMovement((double)mx, (double)my, (double)mz);
    }

    public void setDeltaMovement(double x, double y, double z) {
        super.setDeltaMovement(x + ((double)this.random.nextFloat() - 0.5) / 50.0, y + ((double)this.random.nextFloat() - 0.5) / 50.0, z + ((double)this.random.nextFloat() - 0.5) / 50.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.ticksInAir > 7) {
            this.kill((ServerLevel)this.level());
        }
        this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        float var17 = 0.4f;
        if (this.isInWater()) {
            this.kill((ServerLevel)this.level());
        }
        this.setDeltaMovement(this.getDeltaMovement().scale((double)var17));
        this.applyGravity();
        this.reapplyPosition();
        ++this.ticksInAir;
    }

    protected double getDefaultGravity() {
        return -0.02f;
    }

    protected void addAdditionalSaveData(ValueOutput p_422546_) {
        super.addAdditionalSaveData(p_422546_);
        p_422546_.putDouble("damage", this.damage);
    }

    protected void readAdditionalSaveData(ValueInput p_421811_) {
        super.readAdditionalSaveData(p_421811_);
        this.damage = p_421811_.getDoubleOr("damage", 0.0);
    }

    public boolean isAttackable() {
        return false;
    }
}

