/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.core.BlackList;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityB2Spirit;
import io.github.kadir1243.rivalrebels.common.entity.EntityLightningLink;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.util.ItemUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityRaytrace
extends Projectile {
    private float range = 0.0f;
    private float chance;

    public EntityRaytrace(EntityType<? extends EntityRaytrace> type, Level world) {
        super(type, world);
    }

    public EntityRaytrace(Level level) {
        this((EntityType<? extends EntityRaytrace>)((EntityType)RREntities.RAYTRACE.get()), level);
    }

    public EntityRaytrace(Level level, double mx, double my, double mz) {
        this(level);
        this.yRotO = (float)(Math.atan2(mx, mz) * 57.2957763671875);
        this.setYRot(this.yRotO);
        this.xRotO = (float)(Math.atan2(my, Math.sqrt(mx * mx + mz * mz)) * 57.2957763671875);
        this.setXRot(this.xRotO);
        this.chance = 1.0f;
        this.range = Mth.sqrt((float)((float)(mx * mx + my * my + mz * mz)));
    }

    public EntityRaytrace(Level level, Entity entity, float distance, float randomness, float chance, boolean shift) {
        this(level);
        this.chance = chance;
        this.range = distance;
        this.setOwner(entity);
        this.snapTo(entity.getEyePosition(), entity.getYRot(), entity.getXRot());
        if (shift) {
            this.setPosRaw(this.getX() - (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f), this.getY(), this.getZ() - (double)(Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f));
            this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        } else {
            this.setPosRaw(this.getX() - (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.3f), this.getY() - (double)0.05f, this.getZ() - (double)(Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.3f));
        }
        this.shootFromRotation(entity, entity.getXRot(), entity.getYRot(), 0.0f, this.range, randomness);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        Vec3 vec31 = this.position();
        Vec3 vec3 = this.position().add(this.getDeltaMovement());
        BlockHitResult MOP = this.level().clip(new ClipContext(vec31, vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (MOP != null) {
            vec3 = MOP.getLocation();
        }
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement().x(), this.getDeltaMovement().y(), this.getDeltaMovement().z()).inflate(1.0, 30.0, 1.0));
        double d0 = Double.MAX_VALUE;
        for (Entity entity : list) {
            double d1;
            Optional mop1;
            if (!this.canHitEntity(entity) || !(mop1 = entity.getBoundingBox().inflate(0.5, 0.5, 0.5).clip(vec31, vec3)).isPresent() || !((d1 = vec31.distanceToSqr((Vec3)mop1.get())) < d0)) continue;
            MOP = new EntityHitResult(entity, (Vec3)mop1.get());
            d0 = d1;
        }
        if (MOP != null) {
            if (MOP.getType() == HitResult.Type.BLOCK) {
                BlockPos pos = MOP.getBlockPos();
                if (!this.level().isClientSide()) {
                    this.level().addFreshEntity((Entity)new EntityLightningLink(this.level(), (Entity)this, Math.sqrt(this.distanceToSqr(MOP.getLocation().x, MOP.getLocation().y, MOP.getLocation().z))));
                }
                BlockState BlockHit = this.level().getBlockState(pos);
                float r = this.random.nextFloat();
                if (BlockHit.is(RRBlocks.camo1) || BlockHit.is(RRBlocks.camo2) || BlockHit.is(RRBlocks.camo3)) {
                    if (r * 10.0f <= this.chance) {
                        if (!this.level().isClientSide()) {
                            this.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        }
                        for (int i = 0; i < 4; ++i) {
                            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, (double)pos.getX(), (double)(pos.getY() - 1) + (double)i * 0.5, (double)pos.getZ(), (double)(this.random.nextFloat() - 0.5f) * 0.1, (double)this.random.nextFloat() * 0.05, (double)(this.random.nextFloat() - 0.5f) * 0.1);
                        }
                    }
                } else if (BlockHit.is(RRBlocks.reactive)) {
                    if (r * 15.0f <= this.chance) {
                        if (!this.level().isClientSide()) {
                            this.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        }
                        for (int i = 0; i < 4; ++i) {
                            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, (double)pos.getX(), (double)(pos.getY() - 1) + (double)i * 0.5, (double)pos.getZ(), (double)(this.random.nextFloat() - 0.5f) * 0.1, (double)this.random.nextFloat() * 0.05, (double)(this.random.nextFloat() - 0.5f) * 0.1);
                        }
                    }
                } else if (!BlackList.tesla(BlockHit) && r <= this.chance) {
                    if (!this.level().isClientSide()) {
                        this.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    }
                    for (int i = 0; i < 4; ++i) {
                        this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, (double)pos.getX(), (double)(pos.getY() - 1) + (double)i * 0.5, (double)pos.getZ(), (double)(this.random.nextFloat() - 0.5f) * 0.1, (double)this.random.nextFloat() * 0.05, (double)(this.random.nextFloat() - 0.5f) * 0.1);
                    }
                }
            } else if (MOP.getType() == HitResult.Type.ENTITY) {
                Entity entityHit = ((EntityHitResult)MOP).getEntity();
                if (!this.level().isClientSide()) {
                    this.level().addFreshEntity((Entity)new EntityLightningLink(this.level(), (Entity)this, this.distanceTo(entityHit)));
                }
                if (entityHit instanceof Player) {
                    Player entityPlayerHit = (Player)entityHit;
                    EquipmentSlot slot = ItemUtil.damageRandomArmor((LivingEntity)entityPlayerHit, 14, this.random);
                    int i = slot.getIndex();
                    ItemStack stack = entityPlayerHit.getItemBySlot(slot);
                    if (stack.isEmpty() || stack.has(DataComponents.EQUIPPABLE) && stack.isValidRepairItem(Items.IRON_INGOT.getDefaultInstance())) {
                        entityPlayerHit.hurt(RivalRebelsDamageSource.electricity(this.level()), (float)(RRConfig.SERVER.getTeslaDecay() / ((int)entityHit.distanceTo((Entity)this) + 1) / (i + 1)));
                    } else {
                        entityPlayerHit.hurt(RivalRebelsDamageSource.electricity(this.level()), 1.0f);
                    }
                } else if (entityHit instanceof EntityB2Spirit) {
                    entityHit.hurt(RivalRebelsDamageSource.electricity(this.level()), (float)RRConfig.SERVER.getTeslaDecay() / 1.5f / (float)((int)entityHit.distanceTo((Entity)this) + 1));
                } else {
                    entityHit.hurt(RivalRebelsDamageSource.electricity(this.level()), (float)(RRConfig.SERVER.getTeslaDecay() / ((int)entityHit.distanceTo((Entity)this) + 1)));
                }
            }
        } else if (!this.level().isClientSide()) {
            this.level().addFreshEntity((Entity)new EntityLightningLink(this.level(), (Entity)this, this.range));
        }
        if (!this.level().isClientSide()) {
            this.kill((ServerLevel)this.level());
        }
    }

    protected boolean canHitEntity(Entity target) {
        return super.canHitEntity(target) || target instanceof EntityRhodes;
    }
}

