/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.RhodesType;
import io.github.kadir1243.rivalrebels.common.entity.RhodesTypes;
import io.github.kadir1243.rivalrebels.common.explosion.Explosion;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class EntityRhodesPiece
extends Entity {
    public static final EntityDataAccessor<Float> SCALE = SynchedEntityData.defineId(EntityRhodesPiece.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Holder<RhodesType>> TYPE = SynchedEntityData.defineId(EntityRhodesPiece.class, (EntityDataSerializer)((EntityDataSerializer)RhodesTypes.HOLDER_DATA_SERIALIZER.get()));
    protected double health;
    private float myaw;
    private float mpitch;

    public EntityRhodesPiece(EntityType<? extends EntityRhodesPiece> type, Level w) {
        super(type, w);
        this.setBoundingBox(new AABB(-1.5, -1.5, -1.5, 1.5, 1.5, 1.5));
    }

    public EntityRhodesPiece(EntityType<? extends EntityRhodesPiece> type, Level w, double x, double y, double z, float scale, Holder<RhodesType> rhodesTypeHolder) {
        this(type, w);
        this.setPos(x, y, z);
        this.setScale(scale);
        this.setVariant(rhodesTypeHolder);
        this.myaw = (float)(this.random.nextGaussian() * 20.0);
        this.mpitch = (float)(this.random.nextGaussian() * 20.0);
        this.setDeltaMovement((float)(this.random.nextGaussian() * 0.75), Mth.abs((float)((float)(this.random.nextGaussian() * 0.75))), (float)(this.random.nextGaussian() * 0.75));
    }

    public float getScale() {
        return ((Float)this.entityData.get(SCALE)).floatValue();
    }

    public void setScale(float scale) {
        this.entityData.set(SCALE, (Object)Float.valueOf(scale));
    }

    public Holder<RhodesType> getVariant() {
        return (Holder)this.entityData.get(TYPE);
    }

    public void setVariant(Holder<RhodesType> variant) {
        this.entityData.set(TYPE, variant);
    }

    public int getColorRGBA() {
        return ((RhodesType)this.getVariant().value()).getColor();
    }

    public boolean canBeCollidedWith(@Nullable Entity p_423659_) {
        return true;
    }

    public boolean isPushable() {
        return true;
    }

    public void tick() {
        super.tick();
        if (this.random.nextInt(Math.max(this.getMaxAge() * (RRConfig.SERVER.isRhodesPromode() ? 1 : 30) - this.tickCount, RRConfig.SERVER.isRhodesPromode() ? 100 : 1)) == 0 && !this.level().isClientSide()) {
            this.kill((ServerLevel)this.level());
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(0.999));
        this.myaw *= 0.98f;
        this.mpitch *= 0.98f;
        this.setYRot(this.getYRot() + this.myaw);
        this.setXRot(this.getXRot() + this.mpitch);
        if (this.verticalCollision) {
            this.setXRot(Math.round(this.getXRot() / 90.0f) * 90);
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, 1.0, 0.7));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, 0.1, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    public int getMaxAge() {
        return 100;
    }

    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        if (this.isAlive() && !this.level().isClientSide()) {
            this.health -= (double)amount;
            if (this.health <= 0.0) {
                this.kill(level);
                new Explosion(this.level(), this.getX(), this.getY(), this.getZ(), 6, true, true, RivalRebelsDamageSource.rocket(this.level()));
                this.playSound((SoundEvent)RRSounds.ARTILLERY_EXPLODE.get(), 30.0f, 1.0f);
            }
        }
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SCALE, (Object)Float.valueOf(1.0f));
        builder.define(TYPE, (Object)RivalRebels.RHODES_TYPE_REGISTRY.wrapAsHolder((Object)RhodesTypes.Rhodes));
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        this.health = valueInput.getDoubleOr("health", 0.0);
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        valueOutput.putDouble("health", this.health);
    }
}

