/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityPropulsionFX;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.explosion.Explosion;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.util.ModBlockTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityRocket
extends AbstractArrow {
    public static final ContextKey<Boolean> HAS_FINS = new ContextKey(RRIdentifiers.create("has_fins"));
    public boolean fins = false;
    public int rotation = 45;
    public float slide = 0.0f;
    private boolean inwaterprevtick = false;

    public EntityRocket(EntityType<? extends EntityRocket> type, Level level) {
        super(type, level);
    }

    public EntityRocket(Level world) {
        this((EntityType<? extends EntityRocket>)((EntityType)RREntities.ROCKET.get()), world);
    }

    public EntityRocket(Level level, Entity entity, float inaccuracy) {
        this(level);
        this.fins = false;
        this.setOwner(entity);
        this.snapTo(entity.getEyePosition(), entity.getYRot(), entity.getXRot());
        this.setPos(this.getX() - (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f), this.getY(), this.getZ() - (double)(Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f));
        this.shootFromRotation(entity, entity.getXRot(), entity.getYRot(), 0.0f, 0.5f, inaccuracy);
    }

    public EntityRocket(Level level, double mx, double my, double mz) {
        this(level);
        this.fins = false;
        this.setYRot((float)(Mth.atan2((double)mx, (double)mz) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)my, (double)Math.sqrt(mx * mx + mz * mz)) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void tick() {
        HitResult hitResult;
        super.tick();
        if (this.tickCount == 0) {
            this.rotation = this.random.nextInt(360);
            this.slide = this.random.nextInt(21) - 10;
            for (int i = 0; i < 10; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() - this.getDeltaMovement().x() * 2.0, this.getY() - this.getDeltaMovement().y() * 2.0, this.getZ() - this.getDeltaMovement().z() * 2.0, -this.getDeltaMovement().x() + (double)((this.random.nextFloat() - 0.5f) * 0.1f), -this.getDeltaMovement().y() + ((double)this.random.nextFloat() - 0.5) * (double)0.1f, -this.getDeltaMovement().z() + (double)((this.random.nextFloat() - 0.5f) * 0.1f));
            }
        }
        this.rotation += (int)this.slide;
        this.slide = (float)((double)this.slide * 0.9);
        if (this.tickCount >= RRConfig.SERVER.getRpgDecay()) {
            this.explode();
        }
        if (this.level().isClientSide() && this.tickCount >= 5 && !this.isInWater() && this.tickCount <= 100) {
            this.level().addFreshEntity((Entity)new EntityPropulsionFX(this.level(), this.getX(), this.getY(), this.getZ(), -this.getDeltaMovement().x() * 0.5, -this.getDeltaMovement().y() * 0.5 - 0.1, -this.getDeltaMovement().z() * 0.5));
        }
        if ((hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0))).getType() != HitResult.Type.MISS) {
            this.onHit(hitResult);
        }
        this.setPosRaw(this.getX() + this.getDeltaMovement().y(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        this.updateRotation();
        float var17 = 1.1f;
        if (this.tickCount > 25) {
            var17 = 0.9999f;
        }
        if (this.isInWater()) {
            for (int var7 = 0; var7 < 4; ++var7) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - this.getDeltaMovement().x() * 0.25, this.getY() - this.getDeltaMovement().y() * 0.25, this.getZ() - this.getDeltaMovement().z() * 0.25, this.getDeltaMovement().x(), this.getDeltaMovement().y(), this.getDeltaMovement().z());
            }
            if (!this.inwaterprevtick) {
                this.playSound((SoundEvent)RRSounds.BOMB_ENTERING_WATER.get(), 0.5f, 0.5f);
            }
            var17 = 0.8f;
            this.inwaterprevtick = true;
        }
        this.setDeltaMovement(this.getDeltaMovement().scale((double)var17));
        if (this.tickCount == 3) {
            this.fins = true;
            this.setXRot(this.getXRot() + 22.5f);
        }
        this.reapplyPosition();
    }

    protected ItemStack getDefaultPickupItem() {
        return RRItems.rocket.toStack();
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.hurt(RivalRebelsDamageSource.rocket(this.level()), 48.0f);
        }
        this.explode();
    }

    protected void onHitBlock(BlockHitResult result) {
        BlockState state = this.level().getBlockState(result.getBlockPos());
        if (state.is(ModBlockTags.GLASS_BLOCKS) || state.is(ModBlockTags.GLASS_PANES)) {
            this.level().setBlockAndUpdate(result.getBlockPos(), Blocks.AIR.defaultBlockState());
            this.playSound((SoundEvent)RRSounds.CUCHILLO_GLASS_BREAK.get(), 5.0f, 0.3f);
            return;
        }
        this.explode();
    }

    public void explode() {
        if (this.level().isClientSide()) {
            return;
        }
        this.playSound(this.isInWater() ? (SoundEvent)RRSounds.WET_BOMB_EXPLODED.get() : (SoundEvent)RRSounds.BOMB_EXPLODE.get(), 5.0f, 0.3f);
        new Explosion(this.level(), this.getX(), this.getY(), this.getZ(), RRConfig.SERVER.getRocketExplosionSize(), false, false, RivalRebelsDamageSource.rocket(this.level()));
        this.kill((ServerLevel)this.level());
    }
}

