/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityB83;
import io.github.kadir1243.rivalrebels.common.entity.EntityHackB83;
import io.github.kadir1243.rivalrebels.common.entity.EntityPropulsionFX;
import io.github.kadir1243.rivalrebels.common.entity.RREntities;
import io.github.kadir1243.rivalrebels.common.explosion.Explosion;
import io.github.kadir1243.rivalrebels.common.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntitySeekB83
extends AbstractArrow {
    public boolean fins = false;
    public int rotation = 45;
    public float slide = 0.0f;
    private boolean inwaterprevtick = false;

    public EntitySeekB83(EntityType<? extends EntitySeekB83> type, Level world) {
        super(type, world);
    }

    public EntitySeekB83(Level level) {
        this((EntityType<? extends EntitySeekB83>)((EntityType)RREntities.SEEK_B83.get()), level);
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public EntitySeekB83(Level level, Entity entity, float par3) {
        this(level);
        this.fins = false;
        this.setOwner(entity);
        this.snapTo(entity.getEyePosition(), entity.getYRot(), entity.getXRot());
        this.setPos(this.getX() - (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f), this.getY(), this.getZ() - (double)(Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f));
        this.shootFromRotation(entity, entity.getXRot(), entity.getYRot(), 0.0f, 0.5f, 1.0f);
    }

    public EntitySeekB83(Level level, Entity entity, float par3, float yawdelta) {
        this(level);
        this.setOwner(entity);
        this.fins = false;
        this.snapTo(entity.getEyePosition(), entity.getYRot() + yawdelta, entity.getXRot());
        this.setPos(this.getX() - (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f), this.getY(), this.getZ() - (double)(Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.16f));
        this.shootFromRotation(entity, entity.getXRot(), entity.getYRot(), 0.0f, 0.5f, 1.0f);
    }

    public EntitySeekB83(Level w, double x, double y, double z, double mx, double my, double mz) {
        this(w);
        this.setPos(x + mx * 16.0, y + my * 16.0, z + mz * 16.0);
        this.fins = false;
        this.shoot(mx, my, mz, 0.5f, 0.1f);
    }

    public void tick() {
        HitResult hitResult;
        super.tick();
        if (this.tickCount == 0) {
            this.rotation = this.random.nextInt(360);
            this.slide = this.random.nextInt(21) - 10;
            for (int i = 0; i < 10; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() - this.getDeltaMovement().x() * 2.0, this.getY() - this.getDeltaMovement().y() * 2.0, this.getZ() - this.getDeltaMovement().z() * 2.0, -this.getDeltaMovement().x() + (double)((this.random.nextFloat() - 0.5f) * 0.1f), -this.getDeltaMovement().y() + ((double)this.random.nextFloat() - 0.5) * (double)0.1f, -this.getDeltaMovement().z() + (double)((this.random.nextFloat() - 0.5f) * 0.1f));
            }
        }
        this.rotation += (int)this.slide;
        this.slide = (float)((double)this.slide * 0.9);
        if (this.tickCount >= 800) {
            this.explode(null);
        }
        if (this.level().isClientSide() && this.tickCount >= 5 && !this.isInWater() && this.tickCount <= 100) {
            this.level().addFreshEntity((Entity)new EntityPropulsionFX(this.level(), this.getX(), this.getY(), this.getZ(), -this.getDeltaMovement().x() * 0.5, -this.getDeltaMovement().y() * 0.5 - 0.1, -this.getDeltaMovement().z() * 0.5));
        }
        if ((hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity)).getType() != HitResult.Type.MISS) {
            this.explode(hitResult);
        }
        Vec3 ddvec = this.getDeltaMovement();
        double dist = 1000000.0;
        for (Entity e : this.level().getEntities((Entity)this, AABB.of((BoundingBox)BoundingBox.infinite()))) {
            Vec3 d;
            Vec3 dpos;
            double temp;
            if (!(e instanceof EntityB83) && !(e instanceof EntityHackB83) || !((temp = (dpos = e.position().subtract(this.position())).lengthSqr()) < dist) || !((d = dpos.multiply(this.getDeltaMovement())).x() + d.y() + d.z() > 0.0)) continue;
            dist = temp;
            temp = Math.sqrt(temp) * (double)0.9f;
            ddvec = dpos.scale(1.0 / temp);
        }
        this.setDeltaMovement(ddvec);
        this.setPosRaw(this.getX() + this.getDeltaMovement().x(), this.getY() + this.getDeltaMovement().y(), this.getZ() + this.getDeltaMovement().z());
        this.updateRotation();
        float var17 = 1.1f;
        if (this.tickCount > 25) {
            var17 = 0.9999f;
        }
        if (this.isInWater()) {
            for (int var7 = 0; var7 < 4; ++var7) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - this.getDeltaMovement().x() * 0.25, this.getY() - this.getDeltaMovement().y() * 0.25, this.getZ() - this.getDeltaMovement().z() * 0.25, this.getDeltaMovement().x(), this.getDeltaMovement().y(), this.getDeltaMovement().z());
            }
            if (!this.inwaterprevtick) {
                this.playSound((SoundEvent)RRSounds.BOMB_ENTERING_WATER.get(), 0.5f, 0.5f);
            }
            var17 = 0.8f;
            this.inwaterprevtick = true;
        }
        this.setDeltaMovement(this.getDeltaMovement().scale((double)var17));
        if (this.tickCount == 3) {
            this.fins = true;
            this.setXRot(this.getXRot() + 22.5f);
        }
        this.reapplyPosition();
        ++this.tickCount;
    }

    public void explode(HitResult mop) {
        boolean isInWater = this.isInWater();
        if (mop != null) {
            if (mop.getType() == HitResult.Type.ENTITY) {
                Entity entityHit = ((EntityHitResult)mop).getEntity();
                if (entityHit instanceof EntityHackB83) {
                    entityHit.kill((ServerLevel)this.level());
                    this.level().setBlockAndUpdate(this.blockPosition(), ((Block)RRBlocks.plasmaexplosion.get()).defaultBlockState());
                    this.kill((ServerLevel)this.level());
                } else if (entityHit instanceof Player) {
                    Player player = (Player)entityHit;
                    for (EquipmentSlot slot : EquipmentSlot.values()) {
                        if (!slot.isArmor()) {
                            return;
                        }
                        ItemStack armorStack = player.getItemBySlot(slot);
                        if (armorStack.isEmpty()) continue;
                        armorStack.hurtAndBreak(48, (LivingEntity)player, slot);
                    }
                    this.playSound(isInWater ? (SoundEvent)RRSounds.WET_BOMB_EXPLODED.get() : (SoundEvent)RRSounds.BOMB_EXPLODE.get(), 5.0f, 0.3f);
                    new Explosion(this.level(), this.getX(), this.getY(), this.getZ(), RRConfig.SERVER.getRocketExplosionSize(), false, false, RivalRebelsDamageSource.rocket(this.level()));
                    this.kill((ServerLevel)this.level());
                } else {
                    new Explosion(this.level(), this.getX(), this.getY(), this.getZ(), RRConfig.SERVER.getRocketExplosionSize(), false, false, RivalRebelsDamageSource.rocket(this.level()));
                    this.kill((ServerLevel)this.level());
                }
            } else {
                BlockPos pos = ((BlockHitResult)mop).getBlockPos();
                BlockState state = this.level().getBlockState(pos);
                if (state.is(ModBlockTags.GLASS_BLOCKS) || state.is(ModBlockTags.GLASS_PANES)) {
                    this.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    this.playSound((SoundEvent)RRSounds.CUCHILLO_GLASS_BREAK.get(), 5.0f, 0.3f);
                } else {
                    this.playSound(isInWater ? (SoundEvent)RRSounds.WET_BOMB_EXPLODED.get() : (SoundEvent)RRSounds.BOMB_EXPLODE.get(), 5.0f, 0.3f);
                    new Explosion(this.level(), this.getX(), this.getY(), this.getZ(), RRConfig.SERVER.getRocketExplosionSize(), false, false, RivalRebelsDamageSource.rocket(this.level()));
                    this.kill((ServerLevel)this.level());
                }
            }
        } else {
            this.playSound(isInWater ? (SoundEvent)RRSounds.WET_BOMB_EXPLODED.get() : (SoundEvent)RRSounds.BOMB_EXPLODE.get(), 5.0f, 0.3f);
            new Explosion(this.level(), this.getX(), this.getY(), this.getZ(), RRConfig.SERVER.getRocketExplosionSize(), false, false, RivalRebelsDamageSource.rocket(this.level()));
            this.kill((ServerLevel)this.level());
        }
    }

    protected boolean canHitEntity(Entity target) {
        return super.canHitEntity(target) || target instanceof EntityHackB83 || target instanceof EntityB83;
    }
}

