/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity;

import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.common.entity.RhodesType;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public enum RhodesTypes implements RhodesType
{
    Rhodes,
    Magnesium,
    Arsenic,
    Vanadium,
    Aurum,
    Iodine,
    Iron,
    Astatine,
    Cobalt,
    Strontium,
    Bismuth,
    Zinc,
    Osmium,
    Neon,
    Argent,
    Wolfram,
    Space;

    private static final DeferredRegister<RhodesType> RHODES_TYPES;
    public static final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<Holder<RhodesType>>> HOLDER_DATA_SERIALIZER;
    public static final ResourceLocation DEFAULT_TEXTURE;
    private static final float[] colors;

    @Override
    public int getColor() {
        int colorType = this.ordinal();
        return ARGB.colorFromFloat((float)1.0f, (float)colors[colorType * 3], (float)colors[colorType * 3 + 1], (float)colors[colorType * 3 + 2]);
    }

    public String getSerializedName() {
        return this.name();
    }

    @Override
    public ResourceLocation getTexture() {
        return DEFAULT_TEXTURE;
    }

    public static void init(IEventBus bus) {
        for (RhodesTypes types : RhodesTypes.values()) {
            RHODES_TYPES.register(types.name().toLowerCase(Locale.ROOT), () -> types);
        }
        RHODES_TYPES.register(bus);
    }

    static {
        RHODES_TYPES = DeferredRegister.create(RivalRebels.RHODES_TYPE_REGISTRY, (String)"rivalrebels");
        HOLDER_DATA_SERIALIZER = RivalRebels.DATA_SERIALIZERS.register("rhodes_type_serializer", () -> EntityDataSerializer.forValueType((StreamCodec)ByteBufCodecs.holderRegistry(RivalRebels.RHODES_TYPE_REGISTRY_KEY)));
        DEFAULT_TEXTURE = RRIdentifiers.create("textures/entity/rhodes.png");
        colors = new float[]{1.0f, 1.0f, 1.0f, 0.49019608f, 0.5568628f, 0.7058824f, 0.57254905f, 0.26666668f, 0.26666668f, 0.4f, 0.4f, 0.3764706f, 0.8509804f, 0.7921569f, 0.46666667f, 0.6901961f, 0.49803922f, 0.98039216f, 0.6f, 0.5372549f, 0.34901962f, 0.99215686f, 0.69803923f, 0.5568628f, 0.44705883f, 0.73333335f, 1.0f, 0.9843137f, 0.81960785f, 0.38039216f, 0.5372549f, 0.627451f, 0.56078434f, 0.9019608f, 0.5882353f, 0.98039216f, 0.5058824f, 0.48235294f, 0.6392157f, 0.827451f, 0.92156863f, 0.44313726f, 0.5686275f, 0.6392157f, 0.6862745f, 0.13333334f, 0.12156863f, 0.12156863f, 1.0f, 1.0f, 1.0f};
    }
}

