/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity.brain;

import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.entity.EntityFlameBall;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class ShootFlame
extends Behavior<EntityRhodes> {
    public ShootFlame() {
        super(Map.of(MemoryModuleType.ATTACK_TARGET, MemoryStatus.VALUE_PRESENT));
    }

    protected void tick(ServerLevel level, EntityRhodes owner, long gameTime) {
        super.tick(level, (LivingEntity)owner, gameTime);
        float syaw = Mth.sin((float)(owner.bodyyaw * ((float)Math.PI / 180)));
        float cyaw = Mth.cos((float)(owner.bodyyaw * ((float)Math.PI / 180)));
        float px = (float)owner.getX() - cyaw * 6.4f * owner.getScale();
        float py = (float)owner.getY() + 6.26759f * owner.getScale();
        float pz = (float)owner.getZ() + syaw * 6.4f * owner.getScale();
        LivingEntity target = owner.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        if (target != null && target.canBeSeenAsEnemy()) {
            float x = px - (float)target.getX();
            float y = py - (float)target.getY() - target.getBbHeight() * 0.5f;
            float z = pz - (float)target.getZ();
            float yaw = (EntityRhodes.atan2(x, z) - owner.bodyyaw + 810.0f) % 360.0f - 270.0f;
            float pitch = -EntityRhodes.atan2(Mth.sqrt((float)(x * x + z * z)), y);
            boolean pointing = true;
            if (Mth.abs((float)(owner.rightarmyaw - yaw)) >= 0.001f) {
                owner.rightarmyaw += Math.max(-3.0f, Math.min(3.0f, yaw - owner.rightarmyaw));
                pointing = Mth.abs((float)(owner.rightarmyaw - yaw)) < 0.001f ? (pointing &= true) : false;
            }
            if (Mth.abs((float)(owner.rightarmpitch - pitch)) >= 0.001f) {
                owner.rightarmpitch += Math.max(-3.0f, Math.min(3.0f, pitch - owner.rightarmpitch));
                pointing = Mth.abs((float)(owner.rightarmpitch - pitch)) < 0.001f ? (pointing &= true) : false;
            }
            if (pointing) {
                owner.playSound((SoundEvent)RRSounds.FLAME_THROWER_EXTINGUISH.get());
                float cp = -1.0f / Mth.sqrt((float)(x * x + y * y + z * z));
                owner.level().addFreshEntity((Entity)new EntityFlameBall(owner.level(), px, py, pz, x *= cp, y *= cp, z *= cp, (8.0 + owner.getRandom().nextDouble() * 8.0) * (double)owner.getScale(), 0.4f));
                owner.level().addFreshEntity((Entity)new EntityFlameBall(owner.level(), px, py, pz, x, y, z, (8.0 + owner.getRandom().nextDouble() * 8.0) * (double)owner.getScale(), 0.4f));
            }
        }
        if (!target.canBeSeenAsEnemy()) {
            owner.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        }
    }
}

