/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.entity.brain;

import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityGore;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.util.ItemUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;

public class ShootLaser
extends Behavior<EntityRhodes> {
    public ShootLaser() {
        super(Map.of(MemoryModuleType.ATTACK_TARGET, MemoryStatus.VALUE_PRESENT));
    }

    protected void tick(ServerLevel level, EntityRhodes owner, long gameTime) {
        super.tick(level, (LivingEntity)owner, gameTime);
        float syaw = Mth.sin((float)(owner.bodyyaw * ((float)Math.PI / 180)));
        float cyaw = Mth.cos((float)(owner.bodyyaw * ((float)Math.PI / 180)));
        LivingEntity lastLaserTarget = owner.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        owner.disableAllLasers();
        if (lastLaserTarget != null && lastLaserTarget.canBeSeenAsEnemy()) {
            float x = (float)(owner.getX() - lastLaserTarget.getX());
            float y = (float)(owner.getY() + 13.0 - lastLaserTarget.getY());
            float z = (float)(owner.getZ() - lastLaserTarget.getZ());
            float dot = syaw * x + cyaw * z;
            float pitch = (720.0f - EntityRhodes.atan2(Mth.sqrt((float)(x * x + z * z)) * (dot > 0.0f ? -1.0f : 1.0f), y)) % 360.0f - 270.0f;
            boolean pointing = true;
            if (Mth.abs((float)(owner.headpitch - pitch)) >= 0.001f) {
                owner.headpitch += Math.max(-20.0f, Math.min(20.0f, pitch - owner.headpitch));
                boolean bl = pointing = Mth.abs((float)(owner.headpitch - pitch)) < 3.0f;
            }
            if (pointing) {
                if (owner.endangered) {
                    owner.enableAllLasers();
                } else {
                    owner.setOnLaserData(owner.getRandom().nextInt(2) + 1);
                }
                owner.playSound((SoundEvent)RRSounds.LASER_SHOOT.get(), 30.0f, 0.0f);
                if (lastLaserTarget instanceof Player) {
                    Player player = (Player)lastLaserTarget;
                    ItemUtil.damageRandomArmor((LivingEntity)player, 24, owner.getRandom());
                    lastLaserTarget.hurt(RivalRebelsDamageSource.laserBurst(owner.level()), owner.isAllLaserEnabled() ? 16.0f : 8.0f);
                    if (player.getHealth() < 3.0f && player.isAlive()) {
                        player.hurt(RivalRebelsDamageSource.laserBurst(owner.level()), 2000000.0f);
                        player.deathTime = 0;
                        owner.level().addFreshEntity((Entity)new EntityGore(owner.level(), (Entity)lastLaserTarget, 0, 0));
                        owner.level().addFreshEntity((Entity)new EntityGore(owner.level(), (Entity)lastLaserTarget, 1, 0));
                        owner.level().addFreshEntity((Entity)new EntityGore(owner.level(), (Entity)lastLaserTarget, 2, 0));
                        owner.level().addFreshEntity((Entity)new EntityGore(owner.level(), (Entity)lastLaserTarget, 2, 0));
                        owner.level().addFreshEntity((Entity)new EntityGore(owner.level(), (Entity)lastLaserTarget, 3, 0));
                        owner.level().addFreshEntity((Entity)new EntityGore(owner.level(), (Entity)lastLaserTarget, 3, 0));
                    }
                } else {
                    lastLaserTarget.hurt(RivalRebelsDamageSource.laserBurst(owner.level()), owner.isAllLaserEnabled() ? 16.0f : 8.0f);
                    if (!lastLaserTarget.canBeSeenAsEnemy() || lastLaserTarget.getHealth() < 3.0f) {
                        int i;
                        int mobs;
                        int arms;
                        int legs;
                        owner.playSound((SoundEvent)RRSounds.BLASTER_FIRE.get(), 1.0f, 4.0f);
                        LivingEntity livingEntity = lastLaserTarget;
                        Objects.requireNonNull(livingEntity);
                        LivingEntity livingEntity2 = livingEntity;
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ZombifiedPiglin.class, Zombie.class, Skeleton.class, EnderMan.class, Creeper.class, MagmaCube.class, Slime.class, CaveSpider.class, Spider.class, Ghast.class, EntityRhodes.class}, (Object)livingEntity2, n)) {
                            case 0: {
                                ZombifiedPiglin ignored = (ZombifiedPiglin)livingEntity2;
                                legs = 2;
                                arms = 2;
                                mobs = 2;
                                break;
                            }
                            case 1: {
                                Zombie ignored = (Zombie)livingEntity2;
                                legs = 2;
                                arms = 2;
                                mobs = 1;
                                break;
                            }
                            case 2: {
                                Skeleton ignored = (Skeleton)livingEntity2;
                                legs = 2;
                                arms = 2;
                                mobs = 3;
                                break;
                            }
                            case 3: {
                                EnderMan ignored = (EnderMan)livingEntity2;
                                legs = 2;
                                arms = 2;
                                mobs = 4;
                                break;
                            }
                            case 4: {
                                Creeper ignored = (Creeper)livingEntity2;
                                legs = 4;
                                arms = 0;
                                mobs = 5;
                                break;
                            }
                            case 5: {
                                MagmaCube ignored = (MagmaCube)livingEntity2;
                                legs = 0;
                                arms = 0;
                                mobs = 7;
                                break;
                            }
                            case 6: {
                                Slime ignored = (Slime)livingEntity2;
                                legs = 0;
                                arms = 0;
                                mobs = 6;
                                break;
                            }
                            case 7: {
                                CaveSpider ignored = (CaveSpider)livingEntity2;
                                legs = 8;
                                arms = 0;
                                mobs = 9;
                                break;
                            }
                            case 8: {
                                Spider ignored = (Spider)livingEntity2;
                                legs = 8;
                                arms = 0;
                                mobs = 8;
                                break;
                            }
                            case 9: {
                                Ghast ignored = (Ghast)livingEntity2;
                                legs = 9;
                                arms = 0;
                                mobs = 10;
                                break;
                            }
                            case 10: {
                                EntityRhodes ignored = (EntityRhodes)livingEntity2;
                                return;
                            }
                            default: {
                                legs = (int)(lastLaserTarget.getBoundingBox().getSize() * 2.0);
                                arms = (int)(lastLaserTarget.getBoundingBox().getSize() * 2.0);
                                mobs = 11;
                            }
                        }
                        owner.level().addFreshEntity((Entity)new EntityGore(owner.level(), (Entity)lastLaserTarget, 0, mobs));
                        owner.level().addFreshEntity((Entity)new EntityGore(owner.level(), (Entity)lastLaserTarget, 1, mobs));
                        for (i = 0; i < arms; ++i) {
                            owner.level().addFreshEntity((Entity)new EntityGore(owner.level(), (Entity)lastLaserTarget, 2, mobs));
                        }
                        for (i = 0; i < legs; ++i) {
                            owner.level().addFreshEntity((Entity)new EntityGore(owner.level(), (Entity)lastLaserTarget, 3, mobs));
                        }
                        lastLaserTarget.kill(level);
                    }
                }
            }
        }
    }
}

