/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.explosion;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.block.trap.BlockPetrifiedWood;
import io.github.kadir1243.rivalrebels.common.entity.EntityAntimatterBombBlast;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AntimatterBomb {
    public int posX;
    public int posY;
    public int posZ;
    public BlockPos pos = BlockPos.ZERO;
    public int lastposX = 0;
    public int lastposZ = 0;
    public int radius;
    public Level world;
    private int n = 1;
    private int nlimit;
    private int shell;
    private int leg;
    private int element;
    private int repeatCount = 0;
    private boolean isTree;
    private int treeHeight;
    public int processedchunks = 0;

    public AntimatterBomb(int x, int y, int z, Level world, int rad) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.world = world;
        this.radius = rad;
        this.nlimit = (this.radius + 25) * (this.radius + 25) * 4;
        rad = rad * rad / 2;
        if (world.isClientSide()) {
            return;
        }
        int clamprad = this.radius;
        for (int X = -clamprad; X < clamprad; ++X) {
            int x2 = X * X;
            for (int Z = -clamprad; Z < clamprad; ++Z) {
                if (x2 + Z * Z >= rad) continue;
                BlockPos pos1 = new BlockPos(X + this.pos.getX(), 70, Z + this.pos.getZ());
                while (pos1.getY() > world.getMinY()) {
                    BlockState state = world.getBlockState(pos1);
                    if (!state.getFluidState().isEmpty()) {
                        world.setBlockAndUpdate(pos1, Blocks.AIR.defaultBlockState());
                    }
                    pos1 = pos1.below();
                }
            }
        }
    }

    public void tick(EntityAntimatterBombBlast tsarblast) {
        if (this.n > 0 && this.n < this.nlimit) {
            boolean repeat = this.processChunk(this.lastposX, this.lastposZ);
            this.shell = Mth.floor((double)((Math.sqrt(this.n) + 1.0) / 2.0));
            int shell2 = 2 * this.shell;
            this.leg = Mth.floor((float)((this.n - (shell2 - 1) * (shell2 - 1)) / shell2));
            this.element = this.n - (shell2 - 1) * (shell2 - 1) - shell2 * this.leg - this.shell + 1;
            int n = this.leg == 0 ? this.shell : (this.leg == 1 ? -this.element : (this.lastposX = this.leg == 2 ? -this.shell : this.element));
            this.lastposZ = this.leg == 0 ? this.element : (this.leg == 1 ? this.shell : (this.leg == 2 ? -this.element : -this.shell));
            ++this.n;
            if (!repeat) {
                ++this.repeatCount;
                if (this.repeatCount < RRConfig.SERVER.getTsarBombaSpeed() * 2) {
                    this.tick(tsarblast);
                } else {
                    this.repeatCount = 0;
                }
            }
        } else {
            tsarblast.bomb = null;
            tsarblast.kill((ServerLevel)this.world);
        }
    }

    private boolean processChunk(int x, int z) {
        ++this.processedchunks;
        double dist = x * x + z * z;
        if (dist < (double)(this.radius * this.radius)) {
            dist = Math.sqrt(dist);
            int y = this.getTopBlock(x + this.posX, z + this.posZ, dist);
            float yele = (float)this.posY + (float)(y - this.posY) * 0.5f;
            if (RRConfig.SERVER.isElevation()) {
                yele = y;
            }
            int ylimit = Mth.floor((double)((double)yele - ((double)this.radius - dist) * 4.0));
            for (int Y = y; Y > ylimit && Y != this.world.getMinY(); --Y) {
                BlockState state = this.world.getBlockState(new BlockPos(x + this.posX, Y, z + this.posZ));
                if (state.is(RRBlocks.omegaobj)) {
                    RivalRebels.round.winSigma();
                } else if (state.is(RRBlocks.sigmaobj)) {
                    RivalRebels.round.winOmega();
                }
                this.world.setBlockAndUpdate(new BlockPos(x + this.posX, Y, z + this.posZ), Blocks.AIR.defaultBlockState());
            }
            double limit = (double)(this.radius / 2 + this.world.random.nextInt(this.radius / 4)) + 7.5;
            if (dist < limit) {
                for (int Y = ylimit; Y > ylimit - (this.world.random.nextInt(5) + 2) && Y != this.world.getMinY(); --Y) {
                    BlockState state = this.world.getBlockState(new BlockPos(x + this.posX, Y, z + this.posZ));
                    if (state.is(RRBlocks.omegaobj)) {
                        RivalRebels.round.winSigma();
                    } else if (state.is(RRBlocks.sigmaobj)) {
                        RivalRebels.round.winOmega();
                    }
                    this.world.setBlockAndUpdate(new BlockPos(x + this.posX, Y, z + this.posZ), Blocks.OBSIDIAN.defaultBlockState());
                }
            }
            return true;
        }
        if (dist <= (double)(this.radius * this.radius) * 1.3125 * 1.3125) {
            dist = Math.sqrt(dist);
            int y = this.getTopBlock(x + this.posX, z + this.posZ, dist);
            int ylimit = Mth.ceil((double)(Math.sin((dist - (double)this.radius - (double)(this.radius / 16)) * (double)this.radius * 0.001875) * (double)(this.radius / 16)));
            if (dist >= (double)(this.radius + 5)) {
                int metadata = Mth.floor((double)(16.0 / (double)this.radius * dist));
                if (metadata < 0) {
                    metadata = 0;
                }
                if (++metadata > 15) {
                    metadata = 15;
                }
                for (int Y = ylimit; Y >= this.world.getMinY(); --Y) {
                    int yy = Y + y;
                    BlockState state = this.world.getBlockState(new BlockPos(x + this.posX, yy, z + this.posZ));
                    if (state.is(RRBlocks.omegaobj)) {
                        RivalRebels.round.winSigma();
                        continue;
                    }
                    if (state.is(RRBlocks.sigmaobj)) {
                        RivalRebels.round.winOmega();
                        continue;
                    }
                    if (!this.isTree) {
                        this.world.setBlockAndUpdate(new BlockPos(x + this.posX, yy, z + this.posZ), this.world.getBlockState(new BlockPos(x + this.posX, yy - ylimit, z + this.posZ)));
                        continue;
                    }
                    this.isTree = false;
                    for (int Yy = 0; Yy >= -this.treeHeight; --Yy) {
                        this.world.setBlockAndUpdate(new BlockPos(x + this.posX, yy + Yy, z + this.posZ), (BlockState)((Block)RRBlocks.petrifiedwood.get()).defaultBlockState().setValue((Property)BlockPetrifiedWood.META, (Comparable)Integer.valueOf(metadata)));
                    }
                    break;
                }
            } else {
                BlockState state = this.world.getBlockState(new BlockPos(x + this.posX, y, z + this.posZ));
                if (!state.canOcclude()) {
                    this.world.setBlockAndUpdate(new BlockPos(x + this.posX, y, z + this.posZ), Blocks.AIR.defaultBlockState());
                }
            }
            return true;
        }
        return false;
    }

    private int getTopBlock(int x, int z, double dist) {
        int foundY = this.world.getMinY();
        boolean found = false;
        BlockPos pos = new BlockPos(x, this.world.getMaxY(), z);
        while (pos.getY() > this.world.getMinY()) {
            BlockState state = this.world.getBlockState(pos);
            if (!state.isAir()) {
                if (state.is(RRBlocks.omegaobj)) {
                    RivalRebels.round.winSigma();
                } else if (state.is(RRBlocks.sigmaobj)) {
                    RivalRebels.round.winOmega();
                }
                if (state.is(RRBlocks.reactive)) {
                    int i = 0;
                    while ((double)i < (1.0 - dist / (double)this.radius) * 16.0 + this.world.random.nextDouble() * 2.0) {
                        this.world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        ++i;
                    }
                }
                if (!state.canOcclude() || state.is(BlockTags.LOGS)) {
                    this.world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    if (dist > (double)(this.radius / 2) && state.is(BlockTags.LOGS) && this.world.getBlockState(pos.below()).is(BlockTags.LOGS)) {
                        this.isTree = true;
                    }
                    if (!found && this.isTree) {
                        foundY = pos.getY();
                        found = true;
                    }
                } else {
                    if (!found) {
                        return pos.getY();
                    }
                    this.treeHeight = foundY - pos.getY();
                    return foundY;
                }
            }
            pos = pos.below();
        }
        return foundY;
    }
}

