/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.explosion;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.core.BlackList;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityDebris;
import io.github.kadir1243.rivalrebels.common.entity.EntityFlameBall;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Explosion {
    public Explosion(Level world, double x, double y, double z, int strength, boolean fire, boolean crater, DamageSource dmgsrc) {
        world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, x, y, z, 0.0, 0.0, 0.0);
        if (!world.isClientSide()) {
            if (fire) {
                this.fireSpread(world, x, y, z, strength);
            } else {
                this.createHole(world, x, y, z, strength * strength, crater, 4);
            }
            this.pushAndHurtEntities(world, x, y, z, strength, dmgsrc);
        }
    }

    private void fireSpread(Level world, double x, double y, double z, int radius) {
        int halfradius = radius / 2;
        int tworadius = radius * 2;
        for (int X = -tworadius; X <= tworadius; ++X) {
            for (int Y = -tworadius; Y <= tworadius; ++Y) {
                for (int Z = -tworadius; Z <= tworadius; ++Z) {
                    int dist;
                    int xx = (int)x + X;
                    int yy = (int)y + Y;
                    int zz = (int)z + Z;
                    BlockPos pos = new BlockPos(xx, yy, zz);
                    if (!world.isEmptyBlock(pos) || (dist = (int)Math.sqrt(X * X + Y * Y + Z * Z)) >= radius) continue;
                    int varrand = 1 + dist - halfradius;
                    if (dist < halfradius) {
                        world.setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                        continue;
                    }
                    if (varrand <= 0 || world.random.nextInt(varrand) != 0 && world.random.nextInt(varrand / 2 + 1) != 0) continue;
                    world.setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                }
            }
        }
    }

    private void createHole(Level world, double x, double y, double z, int radius, boolean crater, int delete) {
        int halfradius = radius >> 2;
        int tworadius = radius << 2;
        for (int X = -tworadius; X <= tworadius; ++X) {
            int xx = (int)x + X;
            for (int Y = -tworadius; Y <= tworadius; ++Y) {
                int yy = (int)y + Y;
                for (int Z = -tworadius; Z <= tworadius; ++Z) {
                    int zz = (int)z + Z;
                    BlockPos pos = new BlockPos(xx, yy, zz);
                    BlockState state = world.getBlockState(pos);
                    if (world.isEmptyBlock(pos) || state.is(Blocks.BEDROCK)) continue;
                    int dist = X * X + Y * Y + Z * Z;
                    if (dist <= delete && state.is(RRBlocks.camo1) && state.is(RRBlocks.camo2) && state.is(RRBlocks.camo3)) {
                        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        continue;
                    }
                    if (dist < radius) {
                        int varrand = 1 + dist - halfradius;
                        if (dist < halfradius) {
                            this.breakBlock(world, pos, radius, x, y, z);
                            continue;
                        }
                        if (varrand <= 0 || world.random.nextInt(varrand) != 0 && world.random.nextInt(varrand / 2 + 1) != 0) continue;
                        this.breakBlock(world, pos, radius, x, y, z);
                        continue;
                    }
                    if (dist >= tworadius || Y < 2 && (!((double)dist < (double)radius * 1.5) || Y != 1) || !crater) continue;
                    this.breakBlock(world, pos, radius, x, y, z);
                }
            }
        }
    }

    private void breakBlock(Level world, BlockPos pos, int strength, double x, double y, double z) {
        BlockState state = world.getBlockState(pos);
        if (state.is(RRBlocks.remotecharge)) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            world.playLocalSound(pos, (SoundEvent)RRSounds.REMOTE_CHARGE_EXPLOSION.get(), SoundSource.BLOCKS, 0.5f, 0.3f, false);
            new Explosion(world, x + 0.5, y + 0.5, z + 0.5, RRConfig.SERVER.getChargeExplosionSize(), false, false, RivalRebelsDamageSource.charge(world));
            return;
        }
        if (state.is(RRBlocks.toxicgas) || state.is(Blocks.CHEST) || state.is(Blocks.VINE) || state.is(Blocks.TALL_GRASS) || state.is(RRBlocks.flare) || state.is(RRBlocks.light) || state.is(RRBlocks.light2) || state.is(RRBlocks.reactive) || state.is(RRBlocks.timedbomb)) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            return;
        }
        if (state.is(BlockTags.WOODEN_STAIRS)) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
        if ((state.is(RRBlocks.camo1) || state.is(RRBlocks.camo2) || state.is(RRBlocks.camo3) || state.is(RRBlocks.conduit)) && world.random.nextInt(20) != 0) {
            return;
        }
        if (BlackList.explosion(state)) {
            return;
        }
        EntityDebris e = new EntityDebris(world, pos);
        e.push(new Vec3(x, y, z).subtract(Vec3.atLowerCornerOf((Vec3i)pos)).scale(0.2));
        world.addFreshEntity((Entity)e);
    }

    private void pushAndHurtEntities(Level world, double x, double y, double z, int radius, DamageSource dmgsrc) {
        AABB aabb = new AABB(x, y, z, x, y, z).inflate((double)(radius + 1), (double)(-(radius + 1)), (double)(radius + 1));
        List var9 = world.getEntities(null, aabb);
        Vec3 pos = new Vec3(x, y, z);
        radius *= 4;
        for (Entity entity : var9) {
            Vec3 vector;
            double var33;
            double var13;
            if (entity instanceof EntityDebris || entity instanceof EntityFlameBall || entity instanceof EntityRhodes || !((var13 = Math.sqrt(entity.distanceToSqr(pos)) / (double)radius) <= 1.0) || (var33 = (vector = entity.getEyePosition().subtract(pos)).length()) == 0.0) continue;
            vector = vector.normalize();
            double var32 = ServerExplosion.getSeenPercent((Vec3)pos, (Entity)entity);
            double var34 = (1.0 - var13) * var32;
            entity.hurtServer((ServerLevel)world, dmgsrc, (float)((int)((var34 * var34 + var34) / 2.0 * (double)radius + 1.0)));
            entity.push(vector.scale(var34));
        }
    }
}

