/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.explosion;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityB83;
import io.github.kadir1243.rivalrebels.common.entity.EntityHackB83;
import io.github.kadir1243.rivalrebels.common.entity.EntityNuclearBlast;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.entity.EntityTsarBlast;
import io.github.kadir1243.rivalrebels.common.util.ModBlockTags;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NuclearExplosion {
    public NuclearExplosion(Level world, int x, int y, int z, int strength) {
        if (!world.isClientSide()) {
            this.createHole(world, x, y, z, strength, true);
            this.pushAndHurtEntities(world, x, y, z, strength);
            this.fixLag(world, x, y, z, strength);
        }
    }

    public NuclearExplosion(Level world, int x, int y, int z, int strength, boolean breakobj) {
        if (!world.isClientSide()) {
            this.createHole(world, x, y, z, strength, breakobj);
            this.pushAndHurtEntities(world, x, y, z, strength);
            this.fixLag(world, x, y, z, strength);
        }
    }

    private void createHole(Level world, int x, int y, int z, int radius, boolean breakobj) {
        int halfradius = radius / 2;
        int onepointfiveradius = halfradius * 3;
        int AOC = radius / RRConfig.SERVER.getNuclearBombStrength();
        int onepointfiveradiussqrd = onepointfiveradius * onepointfiveradius;
        int twoAOC = AOC * 2;
        for (int X = -onepointfiveradius; X <= onepointfiveradius; ++X) {
            int xx = x + X;
            int XX = X * X;
            for (int Z = -onepointfiveradius; Z <= onepointfiveradius; ++Z) {
                int ZZ = Z * Z + XX;
                int zz = z + Z;
                for (int Y = -onepointfiveradius; Y <= onepointfiveradius; ++Y) {
                    int YY = Y * Y + ZZ;
                    int yy = y + Y;
                    if (YY >= onepointfiveradiussqrd) continue;
                    BlockPos pos = new BlockPos(xx, yy, zz);
                    BlockState state = world.getBlockState(pos);
                    Block block = state.getBlock();
                    if (world.isEmptyBlock(pos)) continue;
                    int dist = (int)Math.sqrt(YY);
                    if (dist < radius && !state.is(Blocks.BEDROCK)) {
                        int varrand = 1 + dist - halfradius;
                        if (dist < halfradius) {
                            if (breakobj && state.is(RRBlocks.omegaobj)) {
                                RivalRebels.round.winSigma();
                                state = ((Block)RRBlocks.plasmaexplosion.get()).defaultBlockState();
                            } else if (breakobj && state.is(RRBlocks.sigmaobj)) {
                                RivalRebels.round.winOmega();
                                state = ((Block)RRBlocks.plasmaexplosion.get()).defaultBlockState();
                            } else if (state.is(RRBlocks.reactive)) {
                                int i = 0;
                                while ((double)i < (double)((1 - dist / onepointfiveradius) * 4) + world.random.nextDouble() * 2.0) {
                                    world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                                    ++i;
                                }
                            } else {
                                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                                state = Blocks.AIR.defaultBlockState();
                            }
                        } else if (varrand > 0) {
                            int randomness = halfradius - varrand / 2;
                            if (breakobj && state.is(RRBlocks.omegaobj)) {
                                RivalRebels.round.winSigma();
                                state = ((Block)RRBlocks.plasmaexplosion.get()).defaultBlockState();
                            } else if (breakobj && state.is(RRBlocks.sigmaobj)) {
                                RivalRebels.round.winOmega();
                                state = ((Block)RRBlocks.plasmaexplosion.get()).defaultBlockState();
                            } else if (state.is(RRBlocks.reactive)) {
                                int i = 0;
                                while ((double)i < (double)((1 - dist / onepointfiveradius) * 4) + world.random.nextDouble() * 2.0) {
                                    world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                                    ++i;
                                }
                            } else if (!state.getFluidState().isEmpty()) {
                                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                                state = Blocks.AIR.defaultBlockState();
                            } else if (state.is(BlockTags.BASE_STONE_OVERWORLD) && world.random.nextInt(randomness) < randomness / 2) {
                                world.setBlockAndUpdate(pos, Blocks.COBBLESTONE.defaultBlockState());
                                state = Blocks.COBBLESTONE.defaultBlockState();
                            } else if (state.is(BlockTags.DIRT)) {
                                world.setBlockAndUpdate(pos, ((Block)RRBlocks.radioactivedirt.get()).defaultBlockState());
                            } else if (state.is(BlockTags.SAND) || state.is(ModBlockTags.SANDSTONE_BLOCKS)) {
                                world.setBlockAndUpdate(pos, ((Block)RRBlocks.radioactivesand.get()).defaultBlockState());
                            } else if (world.random.nextInt(varrand) == 0 || world.random.nextInt(varrand / 2 + 1) == 0) {
                                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                                state = Blocks.AIR.defaultBlockState();
                            }
                        }
                    }
                    if (dist >= onepointfiveradius || state.isAir() || block == Blocks.BEDROCK) continue;
                    if (Y >= twoAOC || dist < onepointfiveradius && Y >= AOC) {
                        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        continue;
                    }
                    if (world.getBlockState(pos.below()).is(BlockTags.LOGS_THAT_BURN)) {
                        world.setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                        continue;
                    }
                    if (state.is(BlockTags.DIRT)) {
                        world.setBlockAndUpdate(pos, ((Block)RRBlocks.radioactivedirt.get()).defaultBlockState());
                        continue;
                    }
                    if (!state.is(BlockTags.SAND) && !state.is(ModBlockTags.SANDSTONE_BLOCKS)) continue;
                    world.setBlockAndUpdate(pos, ((Block)RRBlocks.radioactivesand.get()).defaultBlockState());
                }
            }
        }
        world.playLocalSound((double)x, (double)y, (double)z, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.MASTER, 4.0f, (1.0f + (world.random.nextFloat() - world.random.nextFloat()) * 0.2f) * 0.7f, true);
    }

    private void pushAndHurtEntities(Level world, int x, int y, int z, int radius) {
        AABB aabb = new AABB((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).inflate((double)((radius *= 4) + 1), (double)(-(radius + 1)), (double)(radius + 1));
        List var9 = world.getEntities(null, aabb);
        Vec3 var30 = new Vec3((double)x, (double)y, (double)z);
        for (Entity entity : var9) {
            Vec3 vector;
            double distance = Math.sqrt(entity.distanceToSqr((double)x, (double)y, (double)z)) / (double)radius;
            if (!(distance <= 1.0) || (vector = entity.getEyePosition().subtract(var30)).length() == 0.0) continue;
            vector = vector.normalize();
            double var32 = ServerExplosion.getSeenPercent((Vec3)var30, (Entity)entity);
            double var34 = (1.0 - distance) * var32 * (double)(entity instanceof EntityB83 || entity instanceof EntityHackB83 ? -1 : 1);
            if (!(entity instanceof EntityNuclearBlast || entity instanceof EntityTsarBlast || entity instanceof EntityRhodes)) {
                if (entity instanceof FallingBlockEntity) {
                    entity.kill((ServerLevel)world);
                }
                entity.hurt(RivalRebelsDamageSource.nuclearBlast(world), (float)((int)((var34 * var34 + var34) / 2.0 * 8.0 * (double)radius + 1.0) * 4));
                entity.setDeltaMovement(entity.getDeltaMovement().subtract(vector.scale(var34 * 8.0)));
            }
            if (!(entity instanceof EntityRhodes)) continue;
            entity.hurt(RivalRebelsDamageSource.nuclearBlast(world), (float)((int)((double)radius * var34 * (double)0.2f)));
        }
    }

    private void fixLag(Level world, int x, int y, int z, int strength) {
        for (int X = -strength; X <= strength; ++X) {
            int xx = x + X;
            for (int Y = -strength; Y <= strength; ++Y) {
                int yy = y + Y;
                for (int Z = -strength; Z <= strength; ++Z) {
                    int zz = z + Z;
                    BlockPos pos = new BlockPos(xx, yy, zz);
                    if (!world.isEmptyBlock(pos) || world.getMaxLocalRawBrightness(pos) != 0) continue;
                    boolean isEmptyNotSideAvailable = Arrays.stream(Direction.values()).map(arg_0 -> ((BlockPos)pos).relative(arg_0)).noneMatch(arg_0 -> ((Level)world).isEmptyBlock(arg_0));
                    if (!isEmptyNotSideAvailable) continue;
                    int r = world.random.nextInt(50);
                    Block id = r == 0 ? world.registryAccess().lookupOrThrow(Registries.BLOCK).getRandomElementOf(ModBlockTags.ORES, world.getRandom()).map(Holder::value).orElse(Blocks.AIR) : world.registryAccess().lookupOrThrow(Registries.BLOCK).getRandomElementOf(RivalRebels.NUCLEAR_STONE_GENERATEABLE, world.getRandom()).map(Holder::value).orElse(Blocks.AIR);
                    world.setBlockAndUpdate(pos, id.defaultBlockState());
                }
            }
        }
    }
}

