/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.item;

import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.util.Translations;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;

public class ItemExPill
extends Item {
    public ItemExPill(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        player.playSound((SoundEvent)RRSounds.PILL.get());
        player.playSound((SoundEvent)RRSounds.VOICE_18.get(), 1.0f, 0.6f);
        player.startUsingItem(hand);
        if (!world.isClientSide()) {
            int random = world.random.nextInt(100);
            if (random >= 40) {
                player.displayClientMessage((Component)Translations.status().append(" ").append((Component)Component.literal((String)"The experiment turned out a success.").withStyle(ChatFormatting.YELLOW)), true);
                player.playSound(SoundEvents.MAGMA_CUBE_JUMP, 1.0f, 1.0f);
                player.playSound(SoundEvents.GHAST_SCREAM, 1.0f, 1.0f);
                player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 30, 20));
                player.getFoodData().eat(20, 200.0f);
                player.heal(20.0f);
            } else if (random >= 30) {
                player.displayClientMessage((Component)Translations.status().append(" ").append((Component)Component.literal((String)"Begr\u00fc\u00dfen Sie den Uber-Soldat.").withStyle(ChatFormatting.YELLOW)), true);
                player.playSound(SoundEvents.MAGMA_CUBE_JUMP, 1.0f, 1.0f);
                player.playSound(SoundEvents.GHAST_SCREAM, 1.0f, 1.0f);
                player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 30, 20));
                player.getFoodData().eat(20, 200.0f);
                player.heal(20.0f);
                player.addEffect(new MobEffectInstance(MobEffects.RESISTANCE, 450, 20));
                player.addEffect(new MobEffectInstance(MobEffects.STRENGTH, 500, 20));
                player.addEffect(new MobEffectInstance(MobEffects.JUMP_BOOST, 300, 2));
                player.addEffect(new MobEffectInstance(MobEffects.HASTE, 500, 2));
                player.addEffect(new MobEffectInstance(MobEffects.SPEED, 550, 2));
                player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 800, 20));
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 20));
            } else if (random >= 20) {
                player.displayClientMessage((Component)Translations.status().append(" ").append((Component)Component.literal((String)"The test subject has perished.").withStyle(ChatFormatting.YELLOW)), true);
                player.playSound(SoundEvents.MAGMA_CUBE_JUMP, 1.0f, 1.0f);
                player.playSound(SoundEvents.GHAST_SCREAM, 1.0f, 1.0f);
                player.hurt(RivalRebelsDamageSource.cyanide(world), 2000.0f);
            } else {
                player.displayClientMessage((Component)Translations.status().append(" ").append((Component)Component.literal((String)"Unexpected results have occurred.").withStyle(ChatFormatting.YELLOW)), true);
                player.playSound(SoundEvents.MAGMA_CUBE_JUMP, 1.0f, 1.0f);
                player.playSound(SoundEvents.GHAST_SCREAM, 1.0f, 1.0f);
                player.addEffect(new MobEffectInstance(MobEffects.NAUSEA, 1500, 20));
                player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 1500, 20));
                player.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 1500, 20));
                player.addEffect(new MobEffectInstance(MobEffects.MINING_FATIGUE, 1500, 20));
                player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 1500, 20));
            }
            stack.consume(1, (LivingEntity)player);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.EAT;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 32;
    }
}

