/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.item;

import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.block.autobuilds.BlockAutoTemplate;
import io.github.kadir1243.rivalrebels.common.command.CommandHotPotato;
import io.github.kadir1243.rivalrebels.common.util.Translations;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ItemPliers
extends Item {
    private int i = 0;

    public ItemPliers(Item.Properties properties) {
        super(properties);
    }

    public ItemStack getCraftingRemainder(ItemStack itemStack) {
        return this.getDefaultInstance();
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (!level.isClientSide()) {
            int t;
            Block block = level.getBlockState(pos).getBlock();
            if (block == RRBlocks.jump.get() && player.isCreative()) {
                CommandHotPotato.pos = pos.above(400);
                player.displayClientMessage(Component.nullToEmpty((String)"Hot Potato drop point set. Use /rrhotpotato to start a round."), false);
            }
            if (block == RRBlocks.remotecharge.get()) {
                t = 25;
                ++this.i;
                player.displayClientMessage((Component)Translations.defuse().append(" %" + this.i * 100 / t), false);
                if (this.i >= t) {
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)RRBlocks.remotecharge.toStack());
                    level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    this.i = 0;
                    return InteractionResult.SUCCESS;
                }
            }
            if (block == RRBlocks.timedbomb.get()) {
                t = 25;
                ++this.i;
                player.displayClientMessage((Component)Translations.defuse().append(" %" + this.i * 100 / t), false);
                if (this.i >= t) {
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)RRBlocks.timedbomb.toStack());
                    level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    level.setBlockAndUpdate(pos.above(), Blocks.AIR.defaultBlockState());
                    this.i = 0;
                    return InteractionResult.SUCCESS;
                }
            }
            if (block instanceof BlockAutoTemplate) {
                BlockAutoTemplate worldBlock = (BlockAutoTemplate)block;
                ++this.i;
                player.displayClientMessage((Component)Translations.status().append(" ").append((Component)Translations.BUILDING.translate(this.i * 100 / worldBlock.time)), false);
                if (this.i >= worldBlock.time) {
                    level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    worldBlock.build(level, pos.getX(), pos.getY(), pos.getZ());
                    this.i = 0;
                    return InteractionResult.SUCCESS;
                }
            }
            if (block == RRBlocks.supplies.get() && level.getBlockState(pos.below()).is(RRBlocks.supplies)) {
                ++this.i;
                player.displayClientMessage((Component)Translations.status().append(" ").append((Component)Translations.BUILDING_TOKAMAK.translate(this.i * 100 / 15)), false);
                if (this.i >= 15) {
                    level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    level.setBlockAndUpdate(pos.below(), ((Block)RRBlocks.reactor.get()).defaultBlockState());
                    this.i = 0;
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }
}

