/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.item;

import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.util.Translations;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;

public class ItemSafePill
extends Item {
    public ItemSafePill(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        if (!world.isClientSide()) {
            player.displayClientMessage((Component)Translations.status().append(" ").append((Component)Component.literal((String)"Regenerating...").withStyle(ChatFormatting.YELLOW)), true);
            player.playSound((SoundEvent)RRSounds.PILL2.get());
            player.playSound((SoundEvent)RRSounds.VOICE_18.get());
            player.playSound(SoundEvents.MAGMA_CUBE_JUMP, 1.0f, 1.0f);
            player.playSound(SoundEvents.GHAST_SCREAM, 1.0f, 1.0f);
            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 10, 20));
            player.getFoodData().eat(10, 200.0f);
            player.heal(10.0f);
            ItemStack stack = player.getItemInHand(hand);
            stack.consume(1, (LivingEntity)player);
            return InteractionResult.SUCCESS;
        }
        return super.use(world, player, hand);
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.EAT;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 32;
    }
}

