/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.item;

import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;

public class ItemTrollHelmet
extends Item {
    public ItemTrollHelmet(Item.Properties properties) {
        super(properties.humanoidArmor(RRItems.TROLL_MATERIAL, ArmorType.HELMET));
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionHand hand = context.getHand();
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        Player player = context.getPlayer();
        Direction facing = context.getClickedFace();
        ItemStack stack = player.getItemInHand(hand);
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (state.is(BlockTags.SNOW) && (Integer)state.getValue((Property)SnowLayerBlock.LAYERS) < 1) {
            facing = Direction.UP;
        } else if (block != Blocks.VINE && block != Blocks.TALL_GRASS && block != Blocks.DEAD_BUSH && !state.canBeReplaced(new BlockPlaceContext(context))) {
            pos = pos.relative(facing);
        }
        if (stack.isEnchanted() || !player.mayUseItemAt(pos, facing, stack)) {
            return InteractionResult.FAIL;
        }
        if (world.isUnobstructed(((Block)RRBlocks.trollFlag.get()).defaultBlockState(), pos, CollisionContext.of((Entity)player))) {
            BlockState flagState = ((Block)RRBlocks.trollFlag.get()).getStateForPlacement(new BlockPlaceContext(player, hand, stack, new BlockHitResult(context.getClickLocation(), facing, pos, false)));
            world.setBlockAndUpdate(pos, flagState);
            SoundType soundType = ((Block)RRBlocks.trollFlag.get()).defaultBlockState().getSoundType((LevelReader)context.getLevel(), context.getClickedPos(), (Entity)context.getPlayer());
            world.playLocalSound(pos, soundType.getStepSound(), SoundSource.PLAYERS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f, false);
            stack.consume(1, (LivingEntity)context.getPlayer());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

