/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.item.weapon;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.entity.EntityPlasmoid;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.util.ItemUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;

public class ItemPlasmaCannon
extends Item {
    public ItemPlasmaCannon(Item.Properties properties) {
        super(properties);
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 64;
    }

    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        ItemStack hydrodStack = ItemUtil.getItemStack(user, RRItems.hydrod.asItem());
        if (user.hasInfiniteMaterials() || !hydrodStack.isEmpty() || RRConfig.SERVER.isInfiniteAmmo()) {
            user.startUsingItem(hand);
            if (!user.hasInfiniteMaterials() && !RRConfig.SERVER.isInfiniteAmmo()) {
                if (!hydrodStack.isEmpty()) {
                    hydrodStack.hurtAndBreak(1, (LivingEntity)user, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    if (hydrodStack.getDamageValue() == hydrodStack.getMaxDamage()) {
                        hydrodStack.consume(1, (LivingEntity)user);
                        user.getInventory().add(RRItems.emptyrod.toStack());
                    }
                    user.startUsingItem(hand);
                } else {
                    return InteractionResult.SUCCESS;
                }
            }
            user.playSound((SoundEvent)RRSounds.PLASMA2.get(), 0.25f, 1.0f);
        } else if (!world.isClientSide()) {
            user.displayClientMessage(Component.nullToEmpty((String)"\u00a7cOut of Hydrogen"), true);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!world.isClientSide()) {
            float f = (float)(this.getUseDuration(stack, user) - remainingUseTicks) / 20.0f;
            if ((f = (f * f + f * 2.0f) * 0.3333f) > 1.0f) {
                f = 1.0f;
            }
            user.playSound((SoundEvent)RRSounds.PLASMA3.get());
            EntityPlasmoid entity = new EntityPlasmoid(world, (Entity)user, (f += 0.2f) + 0.5f, stack.isEnchanted());
            world.addFreshEntity((Entity)entity);
        }
        return false;
    }
}

