/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.item.weapon;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.entity.EntityBomb;
import io.github.kadir1243.rivalrebels.common.entity.EntityRocket;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.util.ItemUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;

public class ItemRPG
extends Item {
    public ItemRPG(Item.Properties properties) {
        super(properties);
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 144;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ItemStack itemStack = ItemUtil.getItemStack(player, RRItems.rocket.asItem());
        if (player.hasInfiniteMaterials() || !itemStack.isEmpty() || RRConfig.SERVER.isInfiniteAmmo()) {
            player.startUsingItem(hand);
            if (!(world.isClientSide() || RRConfig.SERVER.isInfiniteAmmo() || player.hasInfiniteMaterials())) {
                itemStack.consume(1, (LivingEntity)player);
            }
            if (!stack.isEnchanted()) {
                player.playSound((SoundEvent)RRSounds.ROCKET_FIRED.get(), 0.4f, 1.0f);
            } else {
                player.playSound((SoundEvent)RRSounds.GUI_UNKNOWN5.get());
            }
            if (!world.isClientSide()) {
                Object projectile = stack.isEnchanted() ? new EntityBomb(world, (Entity)player, 0.1f) : new EntityRocket(world, (Entity)player, 0.1f);
                projectile.setOwner((Entity)player);
                world.addFreshEntity((Entity)projectile);
            }
        } else if (!world.isClientSide()) {
            player.displayClientMessage(Component.nullToEmpty((String)"\u00a7cOut of ammunition"), false);
        }
        return InteractionResult.PASS;
    }
}

