/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.item.weapon;

import com.mojang.authlib.GameProfile;
import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskLeader;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskOfficer;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskRebel;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskRegular;
import io.github.kadir1243.rivalrebels.common.entity.EntityRoddiskRep;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsRank;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;

public class ItemRodDisk
extends Item {
    boolean pass = false;

    public ItemRodDisk(Item.Properties properties) {
        super(properties);
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 300;
    }

    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        if (!this.pass) {
            user.displayClientMessage(Component.nullToEmpty((String)"Password?"), true);
            this.pass = true;
        }
        user.startUsingItem(hand);
        if (RivalRebels.round.rrplayerlist.getForGameProfile((GameProfile)user.getGameProfile()).rrrank.id > 1) {
            user.playSound((SoundEvent)RRSounds.RODDISK_UNKNOWN2.get());
        } else {
            user.playSound((SoundEvent)RRSounds.RODDISK_UNKNOWN6.get());
        }
        return InteractionResult.SUCCESS;
    }

    public boolean releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!(user instanceof Player)) {
            return false;
        }
        Player player = (Player)user;
        if (!world.isClientSide()) {
            stack.consume(1, user);
            RivalRebelsRank rank = RivalRebels.round.rrplayerlist.getForGameProfile((GameProfile)player.getGameProfile()).rrrank;
            if (rank == RivalRebelsRank.REGULAR) {
                EntityRoddiskRegular entity = new EntityRoddiskRegular(world, (Entity)user, 1.0f);
                world.addFreshEntity((Entity)entity);
                user.playSound((SoundEvent)RRSounds.RODDISK_UNKNOWN7.get());
            } else if (rank == RivalRebelsRank.REBEL) {
                EntityRoddiskRebel entity = new EntityRoddiskRebel(world, (Entity)user, 1.1f);
                world.addFreshEntity((Entity)entity);
                user.playSound((SoundEvent)RRSounds.RODDISK_UNKNOWN7.get());
            } else if (rank == RivalRebelsRank.OFFICER) {
                EntityRoddiskOfficer entity = new EntityRoddiskOfficer(world, (Entity)user, 1.2f);
                world.addFreshEntity((Entity)entity);
                user.playSound((SoundEvent)RRSounds.RODDISK_UNKNOWN3.get());
            } else if (rank == RivalRebelsRank.LEADER) {
                EntityRoddiskLeader entity = new EntityRoddiskLeader(world, (Entity)user, 4.0f);
                world.addFreshEntity((Entity)entity);
                user.playSound((SoundEvent)RRSounds.RODDISK_UNKNOWN3.get());
            } else if (rank == RivalRebelsRank.REP) {
                EntityRoddiskRep entity = new EntityRoddiskRep(world, (Entity)user, 4.0f);
                world.addFreshEntity((Entity)entity);
                user.playSound((SoundEvent)RRSounds.RODDISK_UNKNOWN3.get());
            }
            return false;
        }
        return true;
    }
}

