/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.item.weapon;

import io.github.kadir1243.rivalrebels.RRClient;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.client.gui.GuiTesla;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.core.RivalRebelsDamageSource;
import io.github.kadir1243.rivalrebels.common.entity.EntityRaytrace;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.item.components.RRComponents;
import io.github.kadir1243.rivalrebels.common.util.ItemUtil;
import io.github.kadir1243.rivalrebels.common.util.Translations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemTesla
extends Item {
    boolean message = true;

    public ItemTesla(Item.Properties properties) {
        super(properties.stacksTo(1).enchantable(100).component(RRComponents.TESLA_DIAL, (Object)0));
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.NONE;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 20;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        int degree = ItemTesla.getDegree(stack);
        float chance = (float)Mth.abs((int)(degree - 90)) / 90.0f;
        ItemStack battery = ItemUtil.getItemStack(player, RRItems.battery.asItem());
        if (player.hasInfiniteMaterials() || !battery.isEmpty() || RRConfig.SERVER.isInfiniteAmmo()) {
            if (!RRConfig.SERVER.isInfiniteAmmo()) {
                battery.consume(1, (LivingEntity)player);
                if ((double)chance > 0.33333) {
                    if (battery.isEmpty()) {
                        battery = ItemUtil.getItemStack(player, RRItems.battery.asItem());
                    }
                    battery.consume(1, (LivingEntity)player);
                }
                if ((double)chance > 0.66666) {
                    if (battery.isEmpty()) {
                        battery = ItemUtil.getItemStack(player, RRItems.battery.asItem());
                    }
                    battery.consume(1, (LivingEntity)player);
                }
            }
            player.startUsingItem(hand);
        } else {
            player.displayClientMessage(Component.nullToEmpty((String)"\u00a7cOut of batteries"), false);
        }
        if (this.message) {
            player.displayClientMessage((Component)Translations.orders().append(" ").append((Component)Component.translatable((String)"RivalRebels.message.use")).append(" [R]."), false);
            this.message = false;
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        if (slot != null && level.isClientSide() && RRClient.USE_KEY.isDown() && Minecraft.getInstance().screen == null) {
            Minecraft.getInstance().setScreen((Screen)new GuiTesla(ItemTesla.getDegree(stack)));
        }
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (user.isInWaterOrRain() && !user.isInvulnerableTo((ServerLevel)world, RivalRebelsDamageSource.electricity(world))) {
            user.hurt(RivalRebelsDamageSource.electricity(world), 2.0f);
        }
        if (user.getRandom().nextInt(10) == 0) {
            user.playSound((SoundEvent)RRSounds.TESLA.get());
        }
        int degree = ItemTesla.getDegree(stack);
        float chance = (float)Mth.abs((int)(degree - 90)) / 90.0f;
        if (degree - 90 > 0) {
            chance /= 10.0f;
        }
        float dist = 7.0f + (1.0f - (float)degree / 180.0f) * 73.0f;
        float randomness = (float)degree / 720.0f;
        int num = degree / 25 + 1;
        if (!world.isClientSide()) {
            for (int i = 0; i < num; ++i) {
                world.addFreshEntity((Entity)new EntityRaytrace(world, (Entity)user, dist, randomness, chance, !stack.isEnchanted()));
            }
        }
    }

    public static int getDegree(ItemStack item) {
        if (!item.has(RRComponents.TESLA_DIAL)) {
            return 0;
        }
        return (Integer)item.get(RRComponents.TESLA_DIAL) + 90;
    }
}

