/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.noise;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class RivalRebelsCellularNoise {
    private static final RandomSource random = RandomSource.create();
    private static final int pointa3D = 32;
    private static final Vec3[] points3D = new Vec3[32];
    private static final int frames = 28;
    private static final DynamicTexture[] id = RivalRebelsCellularNoise.genTexture(28, 28, 28);

    private static void refresh3D(RandomSource random) {
        for (int i = 0; i < 32; ++i) {
            RivalRebelsCellularNoise.points3D[i] = new Vec3(random.nextDouble(), random.nextDouble(), random.nextDouble());
        }
    }

    private static double noise(double xin, double yin, double zin) {
        double result = 1.0;
        for (int i = 0; i < 32; ++i) {
            Vec3 point = points3D[i];
            double dist = RivalRebelsCellularNoise.getDist(point, xin, yin, zin);
            if (!(dist <= result)) continue;
            result = dist;
        }
        return Math.sqrt(result) * 4.0 - 0.75;
    }

    private static double getDist(Vec3 point, double xin, double yin, double zin) {
        double result = 1.0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    Vec3 vec = point.subtract(xin + (double)x, yin + (double)y, zin + (double)z);
                    if (!(vec.lengthSqr() < result)) continue;
                    result = vec.lengthSqr();
                }
            }
        }
        return result;
    }

    private static DynamicTexture[] genTexture(int xs, int zs, int ys) {
        DynamicTexture[] ids = new DynamicTexture[ys];
        RivalRebelsCellularNoise.refresh3D(random);
        int red = -69;
        int grn = -120;
        int blu = -1;
        for (int i = 0; i < ys; ++i) {
            NativeImage image = new NativeImage(xs, zs, false);
            for (int x = 0; x < xs; ++x) {
                for (int z = 0; z < zs; ++z) {
                    image.setPixel(x, z, ARGB.color((int)((byte)((RivalRebelsCellularNoise.noise((double)x / (double)xs, (double)z / (double)zs, (double)i / (double)ys) + 1.0) * 127.0)), (int)red, (int)grn, (int)blu));
                }
            }
            DynamicTexture texture = new DynamicTexture("Rival Rebels Cellular Noise", xs, zs, false);
            texture.setClamp(false);
            texture.setPixels(image);
            ids[i] = texture;
        }
        return ids;
    }

    public static DynamicTexture getCurrentRandomId() {
        return id[(int)(System.currentTimeMillis() / 100L % 28L)];
    }
}

